/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class CustomHttpClientFactory {
    private static final SSLConnectionSocketFactory SSL_CONNECTION_SOCKET_FACTORY = CustomHttpClientFactory.gainSSLConnectionSocketFactory();
    private static final Registry<ConnectionSocketFactory> CONNECTION_SOCKET_FACTORY_REGISTRY = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)SSL_CONNECTION_SOCKET_FACTORY).build();
    private static final HttpClientConnectionManager HTTP_CLIENT_CONNECTION_MANAGER = CustomHttpClientFactory.gainHttpClientConnectionManager();
    private static final ConnectionKeepAliveStrategy CONNECTION_KEEP_ALIVE_STRATEGY = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 60000L;
        }
    };
    private static final HttpClientBuilder HTTP_CLIENT_BUILDER = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(true).build()).setConnectionManager(HTTP_CLIENT_CONNECTION_MANAGER).setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE);

    public static CloseableHttpClient createCloseableHttpClient() {
        return HTTP_CLIENT_BUILDER.build();
    }

    private static SSLConnectionSocketFactory gainSSLConnectionSocketFactory() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) {
                    return true;
                }
            }).build();
            return new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static HttpClientConnectionManager gainHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(CONNECTION_SOCKET_FACTORY_REGISTRY);
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(50);
        cm.setValidateAfterInactivity(30000);
        return cm;
    }
}

