/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.utils.ofd;

import com.suwell.utils.ofd.Handler;
import com.suwell.utils.ofd.MapHandler;
import com.suwell.utils.ofd.OperateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OFDTool {
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();
    private Map<String, String> map = new HashMap<String, String>();
    private Map<String, String> data = new HashMap<String, String>();
    private Map<String, Map<String, String>> datas = new HashMap<String, Map<String, String>>();

    public Map<String, String> getMap() {
        return this.map;
    }

    public Map<String, Map<String, String>> getDatas() {
        return this.datas;
    }

    public void ParseXML(File ofd) throws OperateException, IOException {
        try (ZipFile zipFile = new ZipFile(ofd);){
            ZipEntry zipEntry = zipFile.getEntry("OFD.xml");
            if (zipEntry == null) {
                throw new OperateException("The file is not normal OFD", null);
            }
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                SAXParser parser = factory.newSAXParser();
                MapHandler mapHandler = new MapHandler(this.map, this.data);
                parser.parse(inputStream, (DefaultHandler)mapHandler);
                this.map = mapHandler.getMap();
                this.datas = mapHandler.getDatas();
            }
            if (this.map.isEmpty()) {
                throw new OperateException("OFD not find content path !", null);
            }
        }
        catch (ZipException zipException) {
            throw new OperateException("file not zip : ".concat(zipException.getMessage()), zipException);
        }
        catch (ParserConfigurationException | SAXException saxException) {
            throw new OperateException("xml Parser failed  : ".concat(saxException.getMessage()), saxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPageCount(File ofd) throws OperateException, IOException {
        try (ZipFile zipFile = new ZipFile(ofd);){
            SAXParser parser;
            ZipEntry zipEntry = zipFile.getEntry("OFD.xml");
            if (zipEntry == null) {
                throw new OperateException("The file is not normal OFD", null);
            }
            ArrayList<String> list = new ArrayList<String>();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                parser = factory.newSAXParser();
                parser.parse(inputStream, (DefaultHandler)new Handler(list));
            }
            if (list.isEmpty()) {
                throw new OperateException("OFD not find content path !", null);
            }
            zipEntry = zipFile.getEntry((String)list.get(0));
            list.clear();
            inputStream = zipFile.getInputStream(zipEntry);
            var6_10 = null;
            try {
                parser = factory.newSAXParser();
                parser.parse(inputStream, (DefaultHandler)new Handler(list));
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (var6_10 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            int n = list.size();
            return n;
        }
        catch (ZipException zipException) {
            throw new OperateException("file not zip : ".concat(zipException.getMessage()), zipException);
        }
        catch (ParserConfigurationException | SAXException saxException) {
            throw new OperateException("xml Parser failed  : ".concat(saxException.getMessage()), saxException);
        }
    }
}

