/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.extend;

import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class JBTagesXml2Json {
    private static final String NAME = "name";
    private static final String TLTLE = "tltle";
    private static final Gson G = new Gson();

    private JBTagesXml2Json() {
    }

    public static String jbArchivesXmlToJson(File file) throws Exception {
        return JBTagesXml2Json.convert(new SAXReader().read(file).getRootElement());
    }

    public static String jbArchivesXmlToJson(InputStream in) throws Exception {
        return JBTagesXml2Json.convert(new SAXReader().read(in).getRootElement());
    }

    public static String jbArchivesXmlToJson(String xml) throws Exception {
        return JBTagesXml2Json.convert(new SAXReader().read((Reader)new StringReader(xml)).getRootElement());
    }

    private static String convert(Element root) {
        HashMap<String, List<N>> map = new HashMap<String, List<N>>();
        N n = new N();
        JBTagesXml2Json.convert(root, n);
        map.put(n.title, n.getSubNodes());
        return G.toJson(map);
    }

    private static void convert(Element e, N n) {
        List list;
        Attribute attribute = e.attribute(NAME) != null ? e.attribute(NAME) : e.attribute(TLTLE);
        n.setTitle(attribute.getValue());
        String text = e.getText().trim().replace("\n", "");
        if (text != null && text.length() > 0) {
            n.addObjectData(e.getName(), text);
        }
        if ((list = e.elements()) != null && list.size() > 0) {
            for (Object o : list) {
                N cn = new N();
                n.addSubNode(cn);
                Element ele = (Element)o;
                JBTagesXml2Json.convert(ele, cn);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class N {
        private String title;
        private Map<String, Object> ObjectDatas;
        private List<N> SubNodes;

        private N() {
        }

        public String getTitle() {
            return this.title;
        }

        public N setTitle(String title) {
            this.title = title;
            return this;
        }

        public Map<String, Object> getObjectDatas() {
            return this.ObjectDatas;
        }

        public N addObjectData(String k, Object o) {
            if (this.ObjectDatas == null) {
                this.ObjectDatas = new HashMap<String, Object>();
            }
            this.ObjectDatas.put(k, o);
            return this;
        }

        public N addSubNode(N n) {
            if (this.SubNodes == null) {
                this.SubNodes = new ArrayList<N>();
            }
            this.SubNodes.add(n);
            return this;
        }

        public N setObjectDatas(Map<String, Object> objectDatas) {
            this.ObjectDatas = objectDatas;
            return this;
        }

        public List<N> getSubNodes() {
            return this.SubNodes;
        }

        public N setSubNodes(List<N> subNodes) {
            this.SubNodes = subNodes;
            return this;
        }
    }
}

