/*
 * Decompiled with CFR 0.152.
 */
package sviolet.smcrypto;

import com.gm.sm2.SM2Helper;
import com.gm.sm2.SM2KeyHelper;
import com.gm.sm3.SM3Helper;
import com.gm.sm4.SM4Helper;
import com.gm.sm4.SM4ModeAndPaddingEnum;
import com.hanweb.common.security.spi.Sm2CryptoSpi;
import com.hanweb.common.security.spi.Sm3CryptoSpi;
import com.hanweb.common.security.spi.Sm4CryptoSpi;
import com.hanweb.common.util.StringUtil;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sviolet.smcrypto.Sm2Key;
import sviolet.smcrypto.a;
import sviolet.smcrypto.util.Util;

public class SmCryptoUtil {
    private static Sm2CryptoSpi a;
    private static Sm3CryptoSpi b;
    private static Sm4CryptoSpi c;
    private static Logger d;

    private static boolean a(String string) {
        return StringUtils.isNotBlank((String)string);
    }

    private static String b(String string) {
        if (SmCryptoUtil.a(string)) {
            string = string.replaceAll("[\\r\\n]", "");
        }
        return string;
    }

    public static String getSm2PrivateKeyFromMap(Map<String, Object> map) throws Exception {
        return sviolet.smcrypto.a.a(map);
    }

    public static String getSm2PublicKeyFromMap(Map<String, Object> map) {
        String string = null;
        try {
            string = sviolet.smcrypto.a.b(map);
            string = SmCryptoUtil.b(string);
        }
        catch (Exception exception) {
            d.warn("getPublicKey error", (Throwable)exception);
        }
        return string;
    }

    public static Map<String, Object> createSm2KeyMap() throws Exception {
        return sviolet.smcrypto.a.a();
    }

    public static Sm2Key createSm2Key() {
        Sm2Key sm2Key = null;
        sm2Key = a != null ? a.createKey() : sviolet.smcrypto.a.b();
        return sm2Key;
    }

    public static String sm2Encode(String string, String string2) {
        String string3 = null;
        if (a != null) {
            string3 = a.encode(string, string2);
        } else {
            try {
                if (StringUtil.isEmpty((String)string) || StringUtil.isEmpty((String)string2)) {
                    return string3;
                }
                byte[] byArray = null;
                ECPublicKeyParameters eCPublicKeyParameters = SM2KeyHelper.buildECPublicKeyParameters(Hex.decodeHex((String)string2));
                byte[] byArray2 = string.getBytes("utf-8");
                byArray = SM2Helper.encrypt(byArray2, eCPublicKeyParameters, SM2Engine.Mode.C1C3C2);
                string3 = Hex.encodeHexString((byte[])byArray);
            }
            catch (Exception exception) {
                d.warn("sm2ToEncode error", (Throwable)exception);
            }
        }
        return string3;
    }

    public static String sm2Decode(String string, String string2) {
        String string3 = null;
        if (a != null) {
            string3 = a.decode(string, string2);
        } else {
            try {
                if (StringUtil.isEmpty((String)string)) {
                    return string3;
                }
                if (!string.startsWith("04")) {
                    String string4 = string;
                    string = new StringBuilder(18).append("04").append(string4).toString();
                }
                ECPrivateKeyParameters eCPrivateKeyParameters = SM2KeyHelper.buildECPrivateKeyParameters(Hex.decodeHex((String)string2));
                byte[] byArray = SM2Helper.decrypt(Hex.decodeHex((String)string), eCPrivateKeyParameters, SM2Engine.Mode.C1C3C2);
                string3 = new String(byArray, "utf-8");
            }
            catch (Exception exception) {
                d.warn("sm2ToDecode error", (Throwable)exception);
            }
        }
        return string3;
    }

    @Deprecated
    public static String sm3Encode(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String string2 = null;
        try {
            string2 = SmCryptoUtil.sm3Encode(Util.hexStringToBytes(string));
        }
        catch (Exception exception) {
            d.error("sm3Encode error", (Throwable)exception);
        }
        return string2;
    }

    public static String sm3Hash(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String string2 = null;
        if (b != null) {
            string2 = b.encodeHash(string);
        } else {
            try {
                string2 = SmCryptoUtil.sm3Encode(string.getBytes("utf-8"));
            }
            catch (Exception exception) {
                d.error("sm3Encode error", (Throwable)exception);
            }
        }
        return string2;
    }

    public static String sm3Encode(byte[] byArray) {
        if (b != null) {
            return b.encode(byArray);
        }
        byte[] byArray2 = SM3Helper.digest(byArray);
        String string = Hex.encodeHexString((byte[])byArray2);
        return string;
    }

    public static String sm4Encode_ECB(String string, String string2) {
        return SmCryptoUtil.sm4Encode_ECB(string, string2, false);
    }

    public static String sm4Encode_ECB(String string, String string2, boolean bl) {
        String string3 = null;
        if (c != null && !bl) {
            string3 = c.encodeECB(string, string2);
        } else {
            if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
                return null;
            }
            try {
                byte[] byArray = SmCryptoUtil.sm4Encode_ECB(string.getBytes("utf-8"), string2, bl);
                string3 = Base64.encodeBase64String((byte[])byArray);
            }
            catch (Exception exception) {
                d.error("sm4Encode_ECB error", (Throwable)exception);
            }
        }
        return string3;
    }

    public static String sm4Decode_ECB(String string, String string2) {
        return SmCryptoUtil.sm4Decode_ECB(string, string2, false);
    }

    public static String sm4Decode_ECB(String string, String string2, boolean bl) {
        String string3 = null;
        if (c != null && !bl) {
            string3 = c.decodeECB(string, string2);
        } else {
            if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
                return null;
            }
            try {
                byte[] byArray = SmCryptoUtil.sm4Decode_ECB(Base64.decodeBase64((String)string), string2, bl);
                if (byArray == null) {
                    return null;
                }
                string3 = new String(byArray, "utf-8");
            }
            catch (Exception exception) {
                d.error("sm4Decode_ECB error", (Throwable)exception);
            }
        }
        return string3;
    }

    public static byte[] sm4Encode_ECB(byte[] byArray, String string) {
        byte[] byArray2 = null;
        if (c != null) {
            byArray2 = c.encodeECB(byArray, string);
        } else {
            if (byArray == null || StringUtils.isBlank((String)string)) {
                return null;
            }
            try {
                string = Util.fill(string, 16, "*");
                byArray2 = SM4Helper.encrypt(byArray, string.getBytes("utf-8"), SM4ModeAndPaddingEnum.SM4_ECB_PKCS5Padding, null);
            }
            catch (Exception exception) {
                d.error("sm4Encode_ECB error", (Throwable)exception);
            }
        }
        return byArray2;
    }

    public static byte[] sm4Encode_ECB(byte[] byArray, String string, boolean bl) {
        byte[] byArray2 = null;
        if (c != null && !bl) {
            byArray2 = c.encodeECB(byArray, string);
        } else {
            if (byArray == null || StringUtils.isBlank((String)string)) {
                return null;
            }
            try {
                string = Util.fill(string, 16, "*");
                byArray2 = SM4Helper.encrypt(byArray, string.getBytes("utf-8"), SM4ModeAndPaddingEnum.SM4_ECB_PKCS5Padding, null);
            }
            catch (Exception exception) {
                d.error("sm4Encode_ECB error", (Throwable)exception);
            }
        }
        return byArray2;
    }

    public static byte[] sm4Decode_ECB(byte[] byArray, String string) {
        return SmCryptoUtil.sm4Decode_ECB(byArray, string, false);
    }

    public static byte[] sm4Decode_ECB(byte[] byArray, String string, boolean bl) {
        byte[] byArray2 = null;
        if (c != null && !bl) {
            byArray2 = c.decodeECB(byArray, string);
        } else {
            if (byArray == null || StringUtils.isBlank((String)string)) {
                return null;
            }
            try {
                string = Util.fill(string, 16, "*");
                byArray2 = SM4Helper.decrypt(byArray, string.getBytes("utf-8"), SM4ModeAndPaddingEnum.SM4_ECB_PKCS5Padding, null);
            }
            catch (Exception exception) {
                d.error("sm4Decode_ECB error", (Throwable)exception);
            }
        }
        return byArray2;
    }

    public static String sm4Encode_CBC(String string, String string2, String string3) {
        String string4 = null;
        if (c != null) {
            string4 = c.encodeCBC(string, string2, string3);
        } else {
            if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2) || StringUtils.isBlank((String)string3)) {
                return null;
            }
            try {
                byte[] byArray = SmCryptoUtil.sm4Encode_CBC(string.getBytes("utf-8"), string2, string3);
                string4 = Base64.encodeBase64String((byte[])byArray);
            }
            catch (Exception exception) {
                d.error("sm4Encode_CBC error", (Throwable)exception);
            }
        }
        return string4;
    }

    public static String sm4Decode_CBC(String string, String string2, String string3) {
        String string4 = null;
        if (c != null) {
            string4 = c.decodeCBC(string, string2, string3);
        } else {
            if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2) || StringUtils.isBlank((String)string3)) {
                return null;
            }
            try {
                byte[] byArray = SmCryptoUtil.sm4Decode_CBC(Base64.decodeBase64((String)string), string2, string3);
                if (byArray == null) {
                    return null;
                }
                string4 = new String(byArray, "utf-8");
            }
            catch (Exception exception) {
                d.error("sm4Decode_CBC error", (Throwable)exception);
            }
        }
        return string4;
    }

    public static byte[] sm4Encode_CBC(byte[] byArray, String string, String string2) {
        byte[] byArray2 = null;
        if (c != null) {
            byArray2 = c.encodeCBC(byArray, string, string2);
        } else {
            if (byArray == null || StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
                return null;
            }
            try {
                string = Util.fill(string, 16, "*");
                string2 = Util.fill(string2, 16, "*");
                byArray2 = SM4Helper.encrypt(byArray, string.getBytes("utf-8"), SM4ModeAndPaddingEnum.SM4_CBC_PKCS5Padding, string2.getBytes("utf-8"));
            }
            catch (Exception exception) {
                d.error("sm4Encode_CBC error", (Throwable)exception);
            }
        }
        return byArray2;
    }

    public static byte[] sm4Decode_CBC(byte[] byArray, String string, String string2) {
        byte[] byArray2 = null;
        if (c != null) {
            byArray2 = c.decodeCBC(byArray, string, string2);
        } else {
            if (byArray == null || StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
                return null;
            }
            try {
                string = Util.fill(string, 16, "*");
                string2 = Util.fill(string2, 16, "*");
                byArray2 = SM4Helper.decrypt(byArray, string.getBytes("utf-8"), SM4ModeAndPaddingEnum.SM4_CBC_PKCS5Padding, string2.getBytes("utf-8"));
            }
            catch (Exception exception) {
                d.error("sm4Decode_CBC error", (Throwable)exception);
            }
        }
        return byArray2;
    }

    public static void setSm2CryptoSpi(Sm2CryptoSpi sm2CryptoSpi) {
        a = sm2CryptoSpi;
    }

    public static void setSm3CryptoSpi(Sm3CryptoSpi sm3CryptoSpi) {
        b = sm3CryptoSpi;
    }

    public static void setSm4CryptoSpi(Sm4CryptoSpi sm4CryptoSpi) {
        c = sm4CryptoSpi;
    }

    static {
        d = LoggerFactory.getLogger(SmCryptoUtil.class);
    }
}

