/*
 * Decompiled with CFR 0.152.
 */
package com.hanweb.common.util;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.google.common.base.CaseFormat;
import com.hanweb.common.util.NumberUtil;
import com.hanweb.common.util.Properties;
import com.hanweb.common.util.log.Log;
import com.hanweb.common.util.log.LogFactory;
import com.vdurmont.emoji.EmojiParser;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.web.util.UriUtils;

public class StringUtil {
    private static Log g = LogFactory.getInstance(StringUtil.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    String a = "^1(3[0-9]|5[0-35-9]|8[05-9])\\d{8}$";
    String b = "^1(34[0-8]|(3[5-9]|5[017-9]|8[78])\\d)\\d{7}$";
    String c = "^1(3[0-2]|5[256]|8[56])\\d{8}$";
    String d = "^1((33|53|8[09])[0-9]|349)\\d{7}$";
    String e = "^0(10|2[0-5789]|\\d{3})\\d{7,8}$";
    public static final List<Pattern> XSS_INPUT_PATTERNS = new ArrayList<Pattern>();
    public static final String[][] SAFESTRING_REPLACE;
    public static final char[] DEFAULT_ALPHABET;
    static Pattern f;

    public static String encoder(String string) {
        String string2 = null;
        try {
            if (string == null) {
                return "";
            }
            string2 = URLEncoder.encode(string, "utf-8");
            string2 = StringUtil.replace(string2, "+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
            g.error((Object)"encoder error", unsupportedEncodingException);
        }
        return string2;
    }

    public static String decoder(String string) {
        String string2 = null;
        try {
            if (string == null) {
                return "";
            }
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
            g.error((Object)"decoder error", unsupportedEncodingException);
        }
        return string2;
    }

    public static String escapeHTML(String string) {
        if (string == null) {
            return null;
        }
        return freemarker.template.utility.StringUtil.XMLEncNA((String)string);
    }

    public static String escapeJS(String string) {
        if (string == null) {
            return null;
        }
        return freemarker.template.utility.StringUtil.javaScriptStringEnc((String)string);
    }

    @Deprecated
    public static String escapeSqlAndJs(String string) {
        String string2 = StringUtil.escapeSql(string);
        string2 = StringUtil.replace(string2, "/**/", "");
        string2 = StringUtil.replace(string2, "<", "&#60;");
        string2 = StringUtil.replace(string2, ">", "&#62;");
        string2 = StringUtil.replace(string2, "%3C", "&#60;", true);
        string2 = StringUtil.replace(string2, "%3E", "&#62;", true);
        string2 = StringUtil.replace(string2, "expression", "\uff45\uff58\uff50\uff52\uff45\uff53\uff53\uff49\uff4f\uff4e", true);
        string2 = StringUtil.replace(string2, "javascript", "\uff4a\uff41\uff56\uff41\uff53\uff43\uff52\uff49\uff50\uff54", true);
        return string2;
    }

    @Deprecated
    public static String getSafeString(String string, boolean bl) {
        return StringUtil.getSafeString(string);
    }

    public static String getSafeString(String string) {
        return StringUtil.escapeXSS(string);
    }

    public static String escapeXSS(String string) {
        if (string == null) {
            return null;
        }
        string = StringUtil.getString(string);
        for (int i = 0; i < SAFESTRING_REPLACE[0].length; ++i) {
            string = StringUtil.replace(string, SAFESTRING_REPLACE[0][i], SAFESTRING_REPLACE[1][i], true);
        }
        string = string.replaceAll("\u0000", "");
        for (Pattern pattern : XSS_INPUT_PATTERNS) {
            string = pattern.matcher(string).replaceAll("");
        }
        return string;
    }

    public static String removeHTML(String string) {
        if (StringUtil.isNotEmpty(string)) {
            Safelist safelist = new Safelist();
            string = Jsoup.clean((String)string, (Safelist)safelist);
        }
        return string;
    }

    public static String removeEnter(String string) {
        return StringUtils.replaceEach((String)string, (String[])new String[]{"\n", "\r"}, (String[])new String[]{"", ""});
    }

    public static String removeWhitespace(String string) {
        return StringUtils.deleteWhitespace((String)string);
    }

    public static String escapeXHTML(String string) {
        if (string == null) {
            return null;
        }
        return freemarker.template.utility.StringUtil.XHTMLEnc((String)string);
    }

    public static String removeString(String string, String string2) {
        return StringUtils.remove((String)string, (String)string2);
    }

    @Deprecated
    public static String escapeSql(String string) {
        return StringEscapeUtils.escapeSql((String)string);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        return freemarker.template.utility.StringUtil.XMLEnc((String)string);
    }

    public static String getString(Object object) {
        String string = ObjectUtils.toString((Object)object, (String)"");
        string = StringUtil.removeBom(string);
        string = StringUtil.trim(string);
        return string;
    }

    public static String getString(Object object, String string) {
        String string2 = ObjectUtils.toString((Object)object, (String)string);
        if (StringUtil.isEmpty(string2)) {
            string2 = string;
        }
        string2 = StringUtil.removeBom(string2);
        return string2;
    }

    public static String removeBom(String string) {
        if (StringUtil.isNotEmpty(string)) {
            string = string.replace("\ufeff", "");
        }
        return string;
    }

    public static String removeEmoji(String string) {
        if (StringUtil.isNotEmpty(string)) {
            string = EmojiParser.removeAllEmojis((String)string);
        }
        return string;
    }

    public static String subString(String string, String string2, String string3) {
        return StringUtils.substringBetween((String)string, (String)string2, (String)string3);
    }

    @Deprecated
    public static String getStringTrim(Object object) {
        return ObjectUtils.toString((Object)object, (String)"").trim();
    }

    public static String trim(Object object) {
        return ObjectUtils.toString((Object)object, (String)"").trim();
    }

    public static String trimString(Object object, String string) {
        String string2 = StringUtil.getString(object);
        string2 = StringUtil.trim(string2);
        string2 = StringUtil.replace(string2, " ", "<trim-blank>");
        string2 = StringUtil.replace(string2, string, " ");
        string2 = StringUtil.trim(string2);
        string2 = StringUtil.replace(string2, " ", string);
        string2 = StringUtil.replace(string2, "<trim-blank>", " ");
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace((String)string, (String)string2, (String)string3);
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            return null;
        }
        return freemarker.template.utility.StringUtil.replace((String)string, (String)string2, (String)string3, (boolean)bl, (boolean)false);
    }

    public static String replaceFirst(String string, String string2, String string3) {
        return StringUtils.replaceOnce((String)string, (String)string2, (String)string3);
    }

    public static String getUUIDString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getNanoId() {
        return NanoIdUtils.randomNanoId((Random)NanoIdUtils.DEFAULT_NUMBER_GENERATOR, (char[])DEFAULT_ALPHABET, (int)21);
    }

    @Deprecated
    public static Integer[] getIntegerArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        Integer[] integerArray = null;
        if (stringArray != null && stringArray.length > 0) {
            integerArray = new Integer[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                integerArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        return integerArray;
    }

    public static String join(Collection<?> collection, String string) {
        return StringUtils.join(collection, (String)string);
    }

    public static String join(Object[] objectArray, String string) {
        return StringUtils.join((Object[])objectArray, (String)string);
    }

    public static void cleanStringBuffer(StringBuffer ... stringBufferArray) {
        for (int i = 0; i < stringBufferArray.length; ++i) {
            stringBufferArray[i].delete(0, stringBufferArray[i].length());
        }
    }

    public static int countMatches(String string, String string2) {
        return StringUtils.countMatches((String)string, (String)string2);
    }

    public static boolean contains(String string, String string2) {
        return StringUtils.contains((String)string, (String)string2);
    }

    public static String repeat(String string, int n) {
        return StringUtils.repeat((String)string, (int)n);
    }

    public static Integer[] toIntegerArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Integer[] integerArray = new Integer[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            integerArray[i] = Integer.parseInt(stringArray[i]);
        }
        return integerArray;
    }

    public static String paresUrl(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        string = StringUtils.replace((String)string, (String)"\\", (String)"/");
        String[] stringArray = StringUtils.split((String)string, (String)string2);
        StringBuffer stringBuffer = new StringBuffer(0);
        for (int i = 0; i < stringArray.length; ++i) {
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            if (!stringArray[i].startsWith("/")) {
                stringBuffer.append("/");
            }
            stringBuffer.append(stringArray[i]);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuffer.delete(0, 1);
        }
        string = stringBuffer.toString();
        StringUtil.cleanStringBuffer(stringBuffer);
        return string;
    }

    public static boolean startsWith(String string, String string2) {
        return StringUtils.startsWith((String)string, (String)string2);
    }

    public static boolean endsWith(String string, String string2) {
        return StringUtils.endsWith((String)string, (String)string2);
    }

    public static String convertPath(String string, boolean bl) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        string = StringUtils.replace((String)string, (String)"\\", (String)"/");
        if (bl && !string.endsWith("/")) {
            String string2 = string;
            string = new StringBuilder(17).append(string2).append("/").toString();
        }
        return string;
    }

    public static boolean equals(String string, String string2) {
        return StringUtils.equals((String)string, (String)string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return StringUtils.equalsIgnoreCase((String)string, (String)string2);
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isBlank((String)string);
    }

    public static boolean isNotEmpty(String string) {
        return StringUtils.isNotBlank((String)string);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.splitByWholeSeparator((String)string, (String)string2);
    }

    public static List<String> toStringList(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        String[] stringArray = StringUtil.split(string, string2);
        return new ArrayList<String>(Arrays.asList(stringArray));
    }

    public static List<String> toStringList(String string) {
        return StringUtil.toStringList(string, ",");
    }

    public static List<Integer> toIntegerList(String string, String string2) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        String[] stringArray = StringUtil.split(string, string2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (NumberUtil.isNotNumeric(string3)) {
                    return null;
                }
                arrayList.add(NumberUtil.getInt(string3));
            }
        }
        return arrayList;
    }

    public static List<Integer> toIntegerList(String string) {
        return StringUtil.toIntegerList(string, ",");
    }

    public static String limitLen(String string, int n) {
        return StringUtil.limitLen(string, n, "utf-8");
    }

    public static String limitLen(String string, int n, String string2) {
        int n2 = 0;
        String string3 = "";
        if (string != null && string.length() > 0) {
            if (string2 == null || string2.length() == 0) {
                string2 = DEFAULT_CHARSET;
            }
            try {
                int n3 = 0;
                n3 = string.getBytes(string2).length;
                if (n3 <= n) {
                    string3 = string;
                } else {
                    String string4;
                    byte[] byArray;
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length && (n2 += (byArray = (string4 = String.valueOf(cArray[i])).getBytes(DEFAULT_CHARSET)).length) < n; ++i) {
                        char c = cArray[i];
                        String string5 = string3;
                        string3 = new StringBuilder(17).append(string5).append(c).toString();
                    }
                }
            }
            catch (Exception exception) {
                g.error((Object)"\u622a\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38!", exception);
            }
        }
        return string3;
    }

    public static String limitLen(String string, int n, String string2, String string3) {
        string3 = StringUtil.getString(string3);
        int n2 = 0;
        String string4 = "";
        if (string != null && string.length() > 0) {
            if (string2 == null || string2.length() == 0) {
                string2 = DEFAULT_CHARSET;
            }
            try {
                int n3 = 0;
                n3 = string.getBytes(string2).length;
                if (n3 <= n) {
                    string4 = string;
                } else {
                    String string5;
                    String string6;
                    byte[] byArray;
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length && (n2 += (byArray = (string6 = String.valueOf(cArray[i])).getBytes(DEFAULT_CHARSET)).length) < n; ++i) {
                        char c = cArray[i];
                        string5 = string4;
                        string4 = new StringBuilder(17).append(string5).append(c).toString();
                    }
                    String string7 = string3;
                    string5 = string4;
                    string4 = new StringBuilder(32).append(string5).append(string7).toString();
                }
            }
            catch (Exception exception) {
                g.error((Object)"\u622a\u53d6\u5b57\u7b26\u4e32\u957f\u5ea6\u65f6\u53d1\u751f\u5f02\u5e38!", exception);
            }
        }
        return string4;
    }

    public static String toFullUrl(String string, String string2) {
        try {
            if (StringUtil.isNotEmpty(string) && !StringUtil.contains(StringUtil.replace(string, "//", ""), "/")) {
                String string3 = string;
                string = new StringBuilder(17).append(string3).append("/").toString();
            }
            URI uRI = new URI(string);
            URI uRI2 = uRI.resolve(string2);
            URL uRL = uRI2.toURL();
            string2 = uRL.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String convertToDicValue(String string, Map<String, String> map) {
        String string2 = null;
        if (StringUtil.isNotEmpty(string)) {
            String[] stringArray = StringUtil.split(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                String string4 = map.get(string3);
                if (!StringUtil.isNotEmpty(string4)) continue;
                arrayList.add(string4);
            }
            string2 = StringUtil.join(arrayList, ",");
        }
        return string2;
    }

    public static String convertToDicValue(String string, Properties properties) {
        String string2 = null;
        if (StringUtil.isNotEmpty(string)) {
            String[] stringArray = StringUtil.split(string, ",");
            ArrayList<String> arrayList = new ArrayList<String>(2);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                String string4 = properties.getString(string3);
                if (!StringUtil.isNotEmpty(string4)) continue;
                arrayList.add(string4);
            }
            string2 = StringUtil.join(arrayList, ",");
        }
        return string2;
    }

    public static String getExceptionString(Throwable throwable) {
        return ExceptionUtils.getFullStackTrace((Throwable)throwable);
    }

    private static boolean a(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!StringUtil.a(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseByREG(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return f.matcher(string.trim()).find();
    }

    public static boolean isChineseByName(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        String string2 = "\\p{InCJK Unified Ideographs}&amp;&amp;\\P{Cn}";
        Pattern pattern = Pattern.compile(string2);
        return pattern.matcher(string.trim()).find();
    }

    public static String encodeUrl(String string) {
        return StringUtil.encodeUrl(string, "utf-8");
    }

    public static String encodeUrl(String string, String string2) {
        if (StringUtil.isNotEmpty(string) && StringUtil.isNotEmpty(string2)) {
            try {
                string = UriUtils.encodeQuery((String)string, (String)string2);
            }
            catch (Exception exception) {
                g.error((Object)"urlEncode error", exception);
            }
        }
        return string;
    }

    public static String encodeChineseUrl(String string) {
        return StringUtil.encodeChineseUrl(string, "utf-8");
    }

    public static String encodeChineseUrl(String string, String string2) {
        if (StringUtil.isChinese(string) && StringUtil.isNotEmpty(string2)) {
            string = StringUtil.encodeUrl(string, string2);
        }
        return string;
    }

    public static String removeXmlHex(String string) {
        if (StringUtil.isNotEmpty(string)) {
            string = string.replaceAll("[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]", "");
        }
        return string;
    }

    public static int getRealLength(String string) {
        int n = 0;
        if (StringUtil.isEmpty(string)) {
            return n;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0391' && c <= '\uffe5') {
                n += 3;
                continue;
            }
            if (c < '\u0000' || c > '\u00ff') continue;
            ++n;
        }
        return n;
    }

    public static List<String> toLines(String string) {
        List list = null;
        if (StringUtil.isNotEmpty(string)) {
            try {
                list = IOUtils.readLines((InputStream)IOUtils.toInputStream((String)string, (String)"utf-8"), (String)"utf-8");
            }
            catch (Exception exception) {
                g.error((Object)"toLines error", exception);
            }
        }
        return list;
    }

    public static String base64Encode(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty(string)) {
            try {
                string2 = Base64.encodeBase64String((byte[])string.getBytes(DEFAULT_CHARSET));
            }
            catch (Exception exception) {
                g.error((Object)"base64Encode error", exception);
            }
        }
        return string2;
    }

    public static String base64Decode(String string) {
        String string2 = null;
        if (StringUtil.isNotEmpty(string)) {
            try {
                string = string.replaceAll(" +", "+");
                string2 = new String(Base64.decodeBase64((String)string), DEFAULT_CHARSET);
            }
            catch (Exception exception) {
                g.error((Object)"base64Decode error", exception);
            }
        }
        return string2;
    }

    public static String fill(String string, int n, String string2) {
        if (StringUtil.isNotEmpty(string)) {
            int n2 = string.length();
            int n3 = n2 - n;
            if (n3 > 0) {
                string = string.substring(0, n);
            } else if (n3 < 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                while (n3 < 0) {
                    ++n3;
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String underlineToCamel(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
    }

    public static String camelToUnderline(String string) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
    }

    public static String messageFormat(String string, Object ... objectArray) {
        if (StringUtil.isNotEmpty(string)) {
            String[] stringArray = null;
            if (objectArray != null) {
                stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = objectArray[i] == null ? null : StringUtil.getString(objectArray[i]);
                }
            }
            string = MessageFormat.format(string, stringArray);
        }
        return string;
    }

    static {
        XSS_INPUT_PATTERNS.add(Pattern.compile("<script>(.*?)</script>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<iframe(.*?)>(.*?)</iframe>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<input(.*?)>(.*?)</input>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("src[\r\n]*=[\r\n]*([^>]+)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("</script>", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<script(.*?)>", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<input(.*?)>", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("eval\\((.*?)\\)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("expression\\((.*?)\\)", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("javascript:", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("vbscript:", 2));
        XSS_INPUT_PATTERNS.add(Pattern.compile("onload(.*?)=", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("onfocus(.*?)=", 42));
        XSS_INPUT_PATTERNS.add(Pattern.compile("<(.*?)form(.*?)>(.*?)</(.*?)form(.*?)>", 42));
        SAFESTRING_REPLACE = new String[][]{{"\"", "<", ">", "%3C", "%3E", "%250D%250A", "%0D%0A", "%0A", "'"}, {"&quot;", "&lt;", "&gt;", "&#60;", "&#62;", " ", " ", " ", "&apos;"}};
        DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        f = Pattern.compile("[\\u4E00-\\u9FBF]+");
    }
}

