/*
 * Decompiled with CFR 0.152.
 */
package com.suwell.ofd.custom.agent;

import com.google.gson.Gson;
import com.suwell.ofd.custom.agent.ConvertAgent;
import com.suwell.ofd.custom.agent.ConvertCallback;
import com.suwell.ofd.custom.agent.ConvertException;
import com.suwell.ofd.custom.agent.DefaultConvertConfig;
import com.suwell.ofd.custom.agent.HTTPConvertConfig;
import com.suwell.ofd.custom.agent.HttpRequest;
import com.suwell.ofd.custom.agent.Model;
import com.suwell.ofd.custom.agent.ResultException;
import com.suwell.ofd.custom.wrapper.io.IOTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class QuickAgent
extends ConvertAgent {
    private static Logger log = LoggerFactory.getLogger(QuickAgent.class);
    private static Semaphore semaphore = new Semaphore(10);
    private static final String defaultCharset = "utf-8";
    private static final String upload = "quick/upload";
    private static final String download = "quick/download";
    private static final String HEADER_SERVER_PATH = "X-Server-Path";
    private static int ok = 0;
    private static HTTPConvertConfig config = new DefaultConvertConfig();
    private static ThreadLocal<String> hds = new ThreadLocal();
    private String baseURL;

    public static void init(HTTPConvertConfig config) {
        if (config.getMaxThreadCount() > 0) {
            semaphore = new Semaphore(config.getMaxThreadCount());
        }
    }

    public QuickAgent(String url) {
        log.debug("Base url {}", (Object)this.baseURL);
        this.baseURL = url;
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
    }

    public String submit(InputStream packet, String token, boolean raise) throws IOException {
        try {
            Model m = QuickAgent.upload(packet, "packet", this.baseURL);
            if (m.getCode() != ok) {
                throw new ResultException(m);
            }
            return m.getTicket();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void convert(InputStream packet, OutputStream result, String token, boolean raise) throws ConvertException, IOException {
        InputStream in = null;
        try {
            String ticket = this.submit(packet, token, raise);
            in = QuickAgent.download(ticket, result, this.baseURL);
            IOTools.copy((InputStream)in, (OutputStream)result);
        }
        catch (Exception e) {
            try {
                if (e instanceof ResultException) {
                    throw new ConvertException(e.getMessage(), (Throwable)e);
                }
                throw new IOException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOTools.closeQuietly(in);
                throw throwable;
            }
        }
        IOTools.closeQuietly((Closeable)in);
    }

    public void convertNoWait(final InputStream packet, final ConvertCallback callback, final String token, final boolean raise) throws IOException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onStart();
                    QuickAgent.this.convert(packet, callback.openOutput(), token, raise);
                    callback.onSuccess();
                }
                catch (Exception e) {
                    if (e instanceof ConvertException) {
                        ResultException tb = (ResultException)e.getCause();
                        callback.onFailed(tb.getResult().getCode() + "", tb.getResult().getMessage());
                    } else {
                        callback.onException(e);
                    }
                }
                finally {
                    callback.onFinally();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Model upload(InputStream packet, String name, String url) throws Exception {
        semaphore.acquire();
        try {
            HttpRequest hr = HttpRequest.post(url + upload).connectTimeout(config.getConnectTimeoutInMissecond(url, packet.available())).readTimeout(config.getReadTimeoutInMissecond(url, packet.available())).part("file", name, null, packet).trustAllCerts();
            if (hr.code() != 200) {
                throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
            }
            String[] hs = hr.headers(HEADER_SERVER_PATH);
            if (hs != null && hs.length > 1) {
                hds.set(hs[0]);
            }
            String body = hr.body(defaultCharset);
            Model model = (Model)new Gson().fromJson(body, Model.class);
            return model;
        }
        finally {
            semaphore.release();
        }
    }

    static InputStream download(String ticket, OutputStream out, String url) throws Exception {
        HttpRequest hr = HttpRequest.get(url + download.concat("?ticket=" + ticket)).connectTimeout(config.getConnectTimeoutInMissecond(url, -1)).readTimeout(config.getReadTimeoutInMissecond(url, -1)).trustAllCerts();
        if (hds.get() != null) {
            hr.header(HEADER_SERVER_PATH, hds.get());
        }
        if (hr.code() != 200) {
            throw new HttpRequest.HttpRequestException(new IOException(hr.body(defaultCharset)));
        }
        return hr.buffer();
    }
}

