/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;

public class TypeUtil {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        Class<?> type = field.getGenericType();
        if (null == type) {
            type = field.getType();
        }
        return type;
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Class<?> clazz) {
        return TypeUtil.getTypeArgument(clazz, 0);
    }

    public static Type getTypeArgument(Class<?> clazz, int index) {
        Type type = clazz;
        if (!(type instanceof ParameterizedType)) {
            type = clazz.getGenericSuperclass();
        }
        return TypeUtil.getTypeArgument(type, index);
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)type;
            return genericSuperclass.getActualTypeArguments();
        }
        return null;
    }

    public static Type getElementType(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        Method nextMethod = null;
        try {
            if (Iterator.class.isAssignableFrom(clazz)) {
                nextMethod = clazz.getMethod("next", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            throw new UtilException(e);
        }
        return TypeUtil.getReturnType(nextMethod);
    }
}

