/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardUtil {
    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        ClipboardUtil.set(contents, null);
    }

    public static void set(Transferable contents, ClipboardOwner owner) {
        ClipboardUtil.getClipboard().setContents(contents, owner);
    }

    public static Object get(DataFlavor flavor) {
        return ClipboardUtil.get(flavor, null);
    }

    public static Object get(DataFlavor flavor, ClipboardOwner owner) {
        Transferable content = ClipboardUtil.getClipboard().getContents(null);
        if (null != content && content.isDataFlavorSupported(flavor)) {
            try {
                return content.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new UtilException(e);
            }
        }
        return null;
    }

    public static void setStr(String text) {
        ClipboardUtil.set(new StringSelection(text));
    }

    public static String getStr() {
        return (String)ClipboardUtil.get(DataFlavor.stringFlavor);
    }

    public static void setImage(Image image) {
        ClipboardUtil.set(new ImageSelection(image), null);
    }

    public static Image getImage() {
        return (Image)ClipboardUtil.get(DataFlavor.imageFlavor);
    }

    public static class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

