/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.processor;

import com.twitter.hbc.common.DelimitedStreamReader;
import com.twitter.hbc.core.Constants;
import com.twitter.hbc.core.processor.AbstractProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringDelimitedProcessor
extends AbstractProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringDelimitedProcessor.class);
    private static final int DEFAULT_BUFFER_SIZE = 50000;
    private static final int MAX_ALLOWABLE_BUFFER_SIZE = 500000;
    private static final String EMPTY_LINE = "";
    private DelimitedStreamReader reader;

    public StringDelimitedProcessor(BlockingQueue<String> queue) {
        super(queue);
    }

    public StringDelimitedProcessor(BlockingQueue<String> queue, long offerTimeoutMillis) {
        super(queue, offerTimeoutMillis);
    }

    @Override
    public void setup(InputStream input) {
        this.reader = new DelimitedStreamReader(input, Constants.DEFAULT_CHARSET, 50000);
    }

    @Override
    @Nullable
    protected String processNextMessage() throws IOException {
        int delimitedCount = -1;
        for (int retries = 0; delimitedCount < 0 && retries < 3; ++retries) {
            String line = this.reader.readLine();
            if (line == null) {
                throw new IOException("Unable to read new line from stream");
            }
            if (line.equals(EMPTY_LINE)) {
                return null;
            }
            try {
                delimitedCount = Integer.parseInt(line);
                continue;
            }
            catch (NumberFormatException n) {
                logger.warn("Error parsing delimited length", (Throwable)n);
            }
        }
        if (delimitedCount < 0) {
            throw new RuntimeException("Unable to process delimited length");
        }
        if (delimitedCount > 500000) {
            throw new IOException("Unreasonable message size " + delimitedCount);
        }
        return this.reader.read(delimitedCount);
    }
}

