/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.GetSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesMetadata;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1beta.ListSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1beta.SampleQuery;
import com.google.cloud.discoveryengine.v1beta.SampleQueryName;
import com.google.cloud.discoveryengine.v1beta.SampleQueryServiceSettings;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySetName;
import com.google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQueryServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQueryServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SampleQueryServiceClient
implements BackgroundResource {
    private final SampleQueryServiceSettings settings;
    private final SampleQueryServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SampleQueryServiceClient create() throws IOException {
        return SampleQueryServiceClient.create(SampleQueryServiceSettings.newBuilder().build());
    }

    public static final SampleQueryServiceClient create(SampleQueryServiceSettings settings) throws IOException {
        return new SampleQueryServiceClient(settings);
    }

    public static final SampleQueryServiceClient create(SampleQueryServiceStub stub) {
        return new SampleQueryServiceClient(stub);
    }

    protected SampleQueryServiceClient(SampleQueryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SampleQueryServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SampleQueryServiceClient(SampleQueryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SampleQueryServiceSettings getSettings() {
        return this.settings;
    }

    public SampleQueryServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final SampleQuery getSampleQuery(SampleQueryName name) {
        GetSampleQueryRequest request = GetSampleQueryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSampleQuery(request);
    }

    public final SampleQuery getSampleQuery(String name) {
        GetSampleQueryRequest request = GetSampleQueryRequest.newBuilder().setName(name).build();
        return this.getSampleQuery(request);
    }

    public final SampleQuery getSampleQuery(GetSampleQueryRequest request) {
        return (SampleQuery)this.getSampleQueryCallable().call((Object)request);
    }

    public final UnaryCallable<GetSampleQueryRequest, SampleQuery> getSampleQueryCallable() {
        return this.stub.getSampleQueryCallable();
    }

    public final ListSampleQueriesPagedResponse listSampleQueries(SampleQuerySetName parent) {
        ListSampleQueriesRequest request = ListSampleQueriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSampleQueries(request);
    }

    public final ListSampleQueriesPagedResponse listSampleQueries(String parent) {
        ListSampleQueriesRequest request = ListSampleQueriesRequest.newBuilder().setParent(parent).build();
        return this.listSampleQueries(request);
    }

    public final ListSampleQueriesPagedResponse listSampleQueries(ListSampleQueriesRequest request) {
        return (ListSampleQueriesPagedResponse)((Object)this.listSampleQueriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSampleQueriesRequest, ListSampleQueriesPagedResponse> listSampleQueriesPagedCallable() {
        return this.stub.listSampleQueriesPagedCallable();
    }

    public final UnaryCallable<ListSampleQueriesRequest, ListSampleQueriesResponse> listSampleQueriesCallable() {
        return this.stub.listSampleQueriesCallable();
    }

    public final SampleQuery createSampleQuery(SampleQuerySetName parent, SampleQuery sampleQuery, String sampleQueryId) {
        CreateSampleQueryRequest request = CreateSampleQueryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSampleQuery(sampleQuery).setSampleQueryId(sampleQueryId).build();
        return this.createSampleQuery(request);
    }

    public final SampleQuery createSampleQuery(String parent, SampleQuery sampleQuery, String sampleQueryId) {
        CreateSampleQueryRequest request = CreateSampleQueryRequest.newBuilder().setParent(parent).setSampleQuery(sampleQuery).setSampleQueryId(sampleQueryId).build();
        return this.createSampleQuery(request);
    }

    public final SampleQuery createSampleQuery(CreateSampleQueryRequest request) {
        return (SampleQuery)this.createSampleQueryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSampleQueryRequest, SampleQuery> createSampleQueryCallable() {
        return this.stub.createSampleQueryCallable();
    }

    public final SampleQuery updateSampleQuery(SampleQuery sampleQuery, FieldMask updateMask) {
        UpdateSampleQueryRequest request = UpdateSampleQueryRequest.newBuilder().setSampleQuery(sampleQuery).setUpdateMask(updateMask).build();
        return this.updateSampleQuery(request);
    }

    public final SampleQuery updateSampleQuery(UpdateSampleQueryRequest request) {
        return (SampleQuery)this.updateSampleQueryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSampleQueryRequest, SampleQuery> updateSampleQueryCallable() {
        return this.stub.updateSampleQueryCallable();
    }

    public final void deleteSampleQuery(SampleQueryName name) {
        DeleteSampleQueryRequest request = DeleteSampleQueryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSampleQuery(request);
    }

    public final void deleteSampleQuery(String name) {
        DeleteSampleQueryRequest request = DeleteSampleQueryRequest.newBuilder().setName(name).build();
        this.deleteSampleQuery(request);
    }

    public final void deleteSampleQuery(DeleteSampleQueryRequest request) {
        this.deleteSampleQueryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSampleQueryRequest, Empty> deleteSampleQueryCallable() {
        return this.stub.deleteSampleQueryCallable();
    }

    public final OperationFuture<ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesAsync(ImportSampleQueriesRequest request) {
        return this.importSampleQueriesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationCallable() {
        return this.stub.importSampleQueriesOperationCallable();
    }

    public final UnaryCallable<ImportSampleQueriesRequest, Operation> importSampleQueriesCallable() {
        return this.stub.importSampleQueriesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSampleQueriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery, ListSampleQueriesPage, ListSampleQueriesFixedSizeCollection> {
        private ListSampleQueriesFixedSizeCollection(List<ListSampleQueriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSampleQueriesFixedSizeCollection createEmptyCollection() {
            return new ListSampleQueriesFixedSizeCollection(null, 0);
        }

        protected ListSampleQueriesFixedSizeCollection createCollection(List<ListSampleQueriesPage> pages, int collectionSize) {
            return new ListSampleQueriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSampleQueriesPage
    extends AbstractPage<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery, ListSampleQueriesPage> {
        private ListSampleQueriesPage(PageContext<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery> context, ListSampleQueriesResponse response) {
            super(context, (Object)response);
        }

        private static ListSampleQueriesPage createEmptyPage() {
            return new ListSampleQueriesPage(null, null);
        }

        protected ListSampleQueriesPage createPage(PageContext<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery> context, ListSampleQueriesResponse response) {
            return new ListSampleQueriesPage(context, response);
        }

        public ApiFuture<ListSampleQueriesPage> createPageAsync(PageContext<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery> context, ApiFuture<ListSampleQueriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSampleQueriesPagedResponse
    extends AbstractPagedListResponse<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery, ListSampleQueriesPage, ListSampleQueriesFixedSizeCollection> {
        public static ApiFuture<ListSampleQueriesPagedResponse> createAsync(PageContext<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery> context, ApiFuture<ListSampleQueriesResponse> futureResponse) {
            ApiFuture<ListSampleQueriesPage> futurePage = ListSampleQueriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSampleQueriesPagedResponse((ListSampleQueriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSampleQueriesPagedResponse(ListSampleQueriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSampleQueriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

