/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateEvaluationMetadata;
import com.google.cloud.discoveryengine.v1alpha.CreateEvaluationRequest;
import com.google.cloud.discoveryengine.v1alpha.Evaluation;
import com.google.cloud.discoveryengine.v1alpha.EvaluationName;
import com.google.cloud.discoveryengine.v1alpha.EvaluationServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.GetEvaluationRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationResultsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationResultsResponse;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListEvaluationsResponse;
import com.google.cloud.discoveryengine.v1alpha.LocationName;
import com.google.cloud.discoveryengine.v1alpha.stub.EvaluationServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.EvaluationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EvaluationServiceClient
implements BackgroundResource {
    private final EvaluationServiceSettings settings;
    private final EvaluationServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EvaluationServiceClient create() throws IOException {
        return EvaluationServiceClient.create(EvaluationServiceSettings.newBuilder().build());
    }

    public static final EvaluationServiceClient create(EvaluationServiceSettings settings) throws IOException {
        return new EvaluationServiceClient(settings);
    }

    public static final EvaluationServiceClient create(EvaluationServiceStub stub) {
        return new EvaluationServiceClient(stub);
    }

    protected EvaluationServiceClient(EvaluationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EvaluationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EvaluationServiceClient(EvaluationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EvaluationServiceSettings getSettings() {
        return this.settings;
    }

    public EvaluationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Evaluation getEvaluation(EvaluationName name) {
        GetEvaluationRequest request = GetEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEvaluation(request);
    }

    public final Evaluation getEvaluation(String name) {
        GetEvaluationRequest request = GetEvaluationRequest.newBuilder().setName(name).build();
        return this.getEvaluation(request);
    }

    public final Evaluation getEvaluation(GetEvaluationRequest request) {
        return (Evaluation)this.getEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetEvaluationRequest, Evaluation> getEvaluationCallable() {
        return this.stub.getEvaluationCallable();
    }

    public final ListEvaluationsPagedResponse listEvaluations(LocationName parent) {
        ListEvaluationsRequest request = ListEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEvaluations(request);
    }

    public final ListEvaluationsPagedResponse listEvaluations(String parent) {
        ListEvaluationsRequest request = ListEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listEvaluations(request);
    }

    public final ListEvaluationsPagedResponse listEvaluations(ListEvaluationsRequest request) {
        return (ListEvaluationsPagedResponse)((Object)this.listEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEvaluationsRequest, ListEvaluationsPagedResponse> listEvaluationsPagedCallable() {
        return this.stub.listEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListEvaluationsRequest, ListEvaluationsResponse> listEvaluationsCallable() {
        return this.stub.listEvaluationsCallable();
    }

    public final OperationFuture<Evaluation, CreateEvaluationMetadata> createEvaluationAsync(LocationName parent, Evaluation evaluation) {
        CreateEvaluationRequest request = CreateEvaluationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEvaluation(evaluation).build();
        return this.createEvaluationAsync(request);
    }

    public final OperationFuture<Evaluation, CreateEvaluationMetadata> createEvaluationAsync(String parent, Evaluation evaluation) {
        CreateEvaluationRequest request = CreateEvaluationRequest.newBuilder().setParent(parent).setEvaluation(evaluation).build();
        return this.createEvaluationAsync(request);
    }

    public final OperationFuture<Evaluation, CreateEvaluationMetadata> createEvaluationAsync(CreateEvaluationRequest request) {
        return this.createEvaluationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEvaluationRequest, Evaluation, CreateEvaluationMetadata> createEvaluationOperationCallable() {
        return this.stub.createEvaluationOperationCallable();
    }

    public final UnaryCallable<CreateEvaluationRequest, Operation> createEvaluationCallable() {
        return this.stub.createEvaluationCallable();
    }

    public final ListEvaluationResultsPagedResponse listEvaluationResults(EvaluationName evaluation) {
        ListEvaluationResultsRequest request = ListEvaluationResultsRequest.newBuilder().setEvaluation(evaluation == null ? null : evaluation.toString()).build();
        return this.listEvaluationResults(request);
    }

    public final ListEvaluationResultsPagedResponse listEvaluationResults(String evaluation) {
        ListEvaluationResultsRequest request = ListEvaluationResultsRequest.newBuilder().setEvaluation(evaluation).build();
        return this.listEvaluationResults(request);
    }

    public final ListEvaluationResultsPagedResponse listEvaluationResults(ListEvaluationResultsRequest request) {
        return (ListEvaluationResultsPagedResponse)((Object)this.listEvaluationResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEvaluationResultsRequest, ListEvaluationResultsPagedResponse> listEvaluationResultsPagedCallable() {
        return this.stub.listEvaluationResultsPagedCallable();
    }

    public final UnaryCallable<ListEvaluationResultsRequest, ListEvaluationResultsResponse> listEvaluationResultsCallable() {
        return this.stub.listEvaluationResultsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEvaluationResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult, ListEvaluationResultsPage, ListEvaluationResultsFixedSizeCollection> {
        private ListEvaluationResultsFixedSizeCollection(List<ListEvaluationResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEvaluationResultsFixedSizeCollection createEmptyCollection() {
            return new ListEvaluationResultsFixedSizeCollection(null, 0);
        }

        protected ListEvaluationResultsFixedSizeCollection createCollection(List<ListEvaluationResultsPage> pages, int collectionSize) {
            return new ListEvaluationResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEvaluationResultsPage
    extends AbstractPage<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult, ListEvaluationResultsPage> {
        private ListEvaluationResultsPage(PageContext<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult> context, ListEvaluationResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListEvaluationResultsPage createEmptyPage() {
            return new ListEvaluationResultsPage(null, null);
        }

        protected ListEvaluationResultsPage createPage(PageContext<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult> context, ListEvaluationResultsResponse response) {
            return new ListEvaluationResultsPage(context, response);
        }

        public ApiFuture<ListEvaluationResultsPage> createPageAsync(PageContext<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult> context, ApiFuture<ListEvaluationResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEvaluationResultsPagedResponse
    extends AbstractPagedListResponse<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult, ListEvaluationResultsPage, ListEvaluationResultsFixedSizeCollection> {
        public static ApiFuture<ListEvaluationResultsPagedResponse> createAsync(PageContext<ListEvaluationResultsRequest, ListEvaluationResultsResponse, ListEvaluationResultsResponse.EvaluationResult> context, ApiFuture<ListEvaluationResultsResponse> futureResponse) {
            ApiFuture<ListEvaluationResultsPage> futurePage = ListEvaluationResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEvaluationResultsPagedResponse((ListEvaluationResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEvaluationResultsPagedResponse(ListEvaluationResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEvaluationResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation, ListEvaluationsPage, ListEvaluationsFixedSizeCollection> {
        private ListEvaluationsFixedSizeCollection(List<ListEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListEvaluationsFixedSizeCollection createCollection(List<ListEvaluationsPage> pages, int collectionSize) {
            return new ListEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEvaluationsPage
    extends AbstractPage<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation, ListEvaluationsPage> {
        private ListEvaluationsPage(PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> context, ListEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListEvaluationsPage createEmptyPage() {
            return new ListEvaluationsPage(null, null);
        }

        protected ListEvaluationsPage createPage(PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> context, ListEvaluationsResponse response) {
            return new ListEvaluationsPage(context, response);
        }

        public ApiFuture<ListEvaluationsPage> createPageAsync(PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> context, ApiFuture<ListEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation, ListEvaluationsPage, ListEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListEvaluationsPagedResponse> createAsync(PageContext<ListEvaluationsRequest, ListEvaluationsResponse, Evaluation> context, ApiFuture<ListEvaluationsResponse> futureResponse) {
            ApiFuture<ListEvaluationsPage> futurePage = ListEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEvaluationsPagedResponse((ListEvaluationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEvaluationsPagedResponse(ListEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

