/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.RankRequest;
import com.google.cloud.discoveryengine.v1.RankResponse;
import com.google.cloud.discoveryengine.v1.stub.GrpcRankServiceCallableFactory;
import com.google.cloud.discoveryengine.v1.stub.RankServiceStub;
import com.google.cloud.discoveryengine.v1.stub.RankServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRankServiceStub
extends RankServiceStub {
    private static final MethodDescriptor<RankRequest, RankResponse> rankMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1.RankService/Rank").setRequestMarshaller(ProtoUtils.marshaller((Message)RankRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RankResponse.getDefaultInstance())).build();
    private final UnaryCallable<RankRequest, RankResponse> rankCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRankServiceStub create(RankServiceStubSettings settings) throws IOException {
        return new GrpcRankServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRankServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRankServiceStub(RankServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRankServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRankServiceStub(RankServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRankServiceStub(RankServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRankServiceCallableFactory());
    }

    protected GrpcRankServiceStub(RankServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings rankTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rankMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("ranking_config", String.valueOf(request.getRankingConfig()));
            return builder.build();
        }).build();
        this.rankCallable = callableFactory.createUnaryCallable(rankTransportSettings, settings.rankSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<RankRequest, RankResponse> rankCallable() {
        return this.rankCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

