/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.Project;
import com.google.cloud.discoveryengine.v1.ProjectName;
import com.google.cloud.discoveryengine.v1.ProjectServiceSettings;
import com.google.cloud.discoveryengine.v1.ProvisionProjectMetadata;
import com.google.cloud.discoveryengine.v1.ProvisionProjectRequest;
import com.google.cloud.discoveryengine.v1.stub.ProjectServiceStub;
import com.google.cloud.discoveryengine.v1.stub.ProjectServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProjectServiceClient
implements BackgroundResource {
    private final ProjectServiceSettings settings;
    private final ProjectServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final ProjectServiceClient create() throws IOException {
        return ProjectServiceClient.create(ProjectServiceSettings.newBuilder().build());
    }

    public static final ProjectServiceClient create(ProjectServiceSettings settings) throws IOException {
        return new ProjectServiceClient(settings);
    }

    public static final ProjectServiceClient create(ProjectServiceStub stub) {
        return new ProjectServiceClient(stub);
    }

    protected ProjectServiceClient(ProjectServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ProjectServiceClient(ProjectServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ProjectServiceSettings getSettings() {
        return this.settings;
    }

    public ProjectServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(ProjectName name) {
        ProvisionProjectRequest request = ProvisionProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.provisionProjectAsync(request);
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(String name) {
        ProvisionProjectRequest request = ProvisionProjectRequest.newBuilder().setName(name).build();
        return this.provisionProjectAsync(request);
    }

    public final OperationFuture<Project, ProvisionProjectMetadata> provisionProjectAsync(ProvisionProjectRequest request) {
        return this.provisionProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable() {
        return this.stub.provisionProjectOperationCallable();
    }

    public final UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable() {
        return this.stub.provisionProjectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

