/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.DeleteIdentityMappingStoreMetadata;
import com.google.cloud.discoveryengine.v1.DeleteIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.GetIdentityMappingStoreRequest;
import com.google.cloud.discoveryengine.v1.IdentityMappingEntry;
import com.google.cloud.discoveryengine.v1.IdentityMappingEntryOperationMetadata;
import com.google.cloud.discoveryengine.v1.IdentityMappingStore;
import com.google.cloud.discoveryengine.v1.IdentityMappingStoreName;
import com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceSettings;
import com.google.cloud.discoveryengine.v1.ImportIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.ImportIdentityMappingsResponse;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingStoresRequest;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingStoresResponse;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.ListIdentityMappingsResponse;
import com.google.cloud.discoveryengine.v1.LocationName;
import com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest;
import com.google.cloud.discoveryengine.v1.stub.IdentityMappingStoreServiceStub;
import com.google.cloud.discoveryengine.v1.stub.IdentityMappingStoreServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IdentityMappingStoreServiceClient
implements BackgroundResource {
    private final IdentityMappingStoreServiceSettings settings;
    private final IdentityMappingStoreServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final IdentityMappingStoreServiceClient create() throws IOException {
        return IdentityMappingStoreServiceClient.create(IdentityMappingStoreServiceSettings.newBuilder().build());
    }

    public static final IdentityMappingStoreServiceClient create(IdentityMappingStoreServiceSettings settings) throws IOException {
        return new IdentityMappingStoreServiceClient(settings);
    }

    public static final IdentityMappingStoreServiceClient create(IdentityMappingStoreServiceStub stub) {
        return new IdentityMappingStoreServiceClient(stub);
    }

    protected IdentityMappingStoreServiceClient(IdentityMappingStoreServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IdentityMappingStoreServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected IdentityMappingStoreServiceClient(IdentityMappingStoreServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final IdentityMappingStoreServiceSettings getSettings() {
        return this.settings;
    }

    public IdentityMappingStoreServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final IdentityMappingStore createIdentityMappingStore(LocationName parent, IdentityMappingStore identityMappingStore, String identityMappingStoreId) {
        CreateIdentityMappingStoreRequest request = CreateIdentityMappingStoreRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIdentityMappingStore(identityMappingStore).setIdentityMappingStoreId(identityMappingStoreId).build();
        return this.createIdentityMappingStore(request);
    }

    public final IdentityMappingStore createIdentityMappingStore(String parent, IdentityMappingStore identityMappingStore, String identityMappingStoreId) {
        CreateIdentityMappingStoreRequest request = CreateIdentityMappingStoreRequest.newBuilder().setParent(parent).setIdentityMappingStore(identityMappingStore).setIdentityMappingStoreId(identityMappingStoreId).build();
        return this.createIdentityMappingStore(request);
    }

    public final IdentityMappingStore createIdentityMappingStore(CreateIdentityMappingStoreRequest request) {
        return (IdentityMappingStore)this.createIdentityMappingStoreCallable().call((Object)request);
    }

    public final UnaryCallable<CreateIdentityMappingStoreRequest, IdentityMappingStore> createIdentityMappingStoreCallable() {
        return this.stub.createIdentityMappingStoreCallable();
    }

    public final IdentityMappingStore getIdentityMappingStore(IdentityMappingStoreName name) {
        GetIdentityMappingStoreRequest request = GetIdentityMappingStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIdentityMappingStore(request);
    }

    public final IdentityMappingStore getIdentityMappingStore(String name) {
        GetIdentityMappingStoreRequest request = GetIdentityMappingStoreRequest.newBuilder().setName(name).build();
        return this.getIdentityMappingStore(request);
    }

    public final IdentityMappingStore getIdentityMappingStore(GetIdentityMappingStoreRequest request) {
        return (IdentityMappingStore)this.getIdentityMappingStoreCallable().call((Object)request);
    }

    public final UnaryCallable<GetIdentityMappingStoreRequest, IdentityMappingStore> getIdentityMappingStoreCallable() {
        return this.stub.getIdentityMappingStoreCallable();
    }

    public final OperationFuture<Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreAsync(IdentityMappingStoreName name) {
        DeleteIdentityMappingStoreRequest request = DeleteIdentityMappingStoreRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIdentityMappingStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreAsync(String name) {
        DeleteIdentityMappingStoreRequest request = DeleteIdentityMappingStoreRequest.newBuilder().setName(name).build();
        return this.deleteIdentityMappingStoreAsync(request);
    }

    public final OperationFuture<Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreAsync(DeleteIdentityMappingStoreRequest request) {
        return this.deleteIdentityMappingStoreOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIdentityMappingStoreRequest, Empty, DeleteIdentityMappingStoreMetadata> deleteIdentityMappingStoreOperationCallable() {
        return this.stub.deleteIdentityMappingStoreOperationCallable();
    }

    public final UnaryCallable<DeleteIdentityMappingStoreRequest, Operation> deleteIdentityMappingStoreCallable() {
        return this.stub.deleteIdentityMappingStoreCallable();
    }

    public final OperationFuture<ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsAsync(ImportIdentityMappingsRequest request) {
        return this.importIdentityMappingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportIdentityMappingsRequest, ImportIdentityMappingsResponse, IdentityMappingEntryOperationMetadata> importIdentityMappingsOperationCallable() {
        return this.stub.importIdentityMappingsOperationCallable();
    }

    public final UnaryCallable<ImportIdentityMappingsRequest, Operation> importIdentityMappingsCallable() {
        return this.stub.importIdentityMappingsCallable();
    }

    public final OperationFuture<Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsAsync(PurgeIdentityMappingsRequest request) {
        return this.purgeIdentityMappingsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PurgeIdentityMappingsRequest, Empty, IdentityMappingEntryOperationMetadata> purgeIdentityMappingsOperationCallable() {
        return this.stub.purgeIdentityMappingsOperationCallable();
    }

    public final UnaryCallable<PurgeIdentityMappingsRequest, Operation> purgeIdentityMappingsCallable() {
        return this.stub.purgeIdentityMappingsCallable();
    }

    public final ListIdentityMappingsPagedResponse listIdentityMappings(ListIdentityMappingsRequest request) {
        return (ListIdentityMappingsPagedResponse)((Object)this.listIdentityMappingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIdentityMappingsRequest, ListIdentityMappingsPagedResponse> listIdentityMappingsPagedCallable() {
        return this.stub.listIdentityMappingsPagedCallable();
    }

    public final UnaryCallable<ListIdentityMappingsRequest, ListIdentityMappingsResponse> listIdentityMappingsCallable() {
        return this.stub.listIdentityMappingsCallable();
    }

    public final ListIdentityMappingStoresPagedResponse listIdentityMappingStores(LocationName parent) {
        ListIdentityMappingStoresRequest request = ListIdentityMappingStoresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIdentityMappingStores(request);
    }

    public final ListIdentityMappingStoresPagedResponse listIdentityMappingStores(String parent) {
        ListIdentityMappingStoresRequest request = ListIdentityMappingStoresRequest.newBuilder().setParent(parent).build();
        return this.listIdentityMappingStores(request);
    }

    public final ListIdentityMappingStoresPagedResponse listIdentityMappingStores(ListIdentityMappingStoresRequest request) {
        return (ListIdentityMappingStoresPagedResponse)((Object)this.listIdentityMappingStoresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIdentityMappingStoresRequest, ListIdentityMappingStoresPagedResponse> listIdentityMappingStoresPagedCallable() {
        return this.stub.listIdentityMappingStoresPagedCallable();
    }

    public final UnaryCallable<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse> listIdentityMappingStoresCallable() {
        return this.stub.listIdentityMappingStoresCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListIdentityMappingStoresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore, ListIdentityMappingStoresPage, ListIdentityMappingStoresFixedSizeCollection> {
        private ListIdentityMappingStoresFixedSizeCollection(List<ListIdentityMappingStoresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIdentityMappingStoresFixedSizeCollection createEmptyCollection() {
            return new ListIdentityMappingStoresFixedSizeCollection(null, 0);
        }

        protected ListIdentityMappingStoresFixedSizeCollection createCollection(List<ListIdentityMappingStoresPage> pages, int collectionSize) {
            return new ListIdentityMappingStoresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIdentityMappingStoresPage
    extends AbstractPage<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore, ListIdentityMappingStoresPage> {
        private ListIdentityMappingStoresPage(PageContext<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore> context, ListIdentityMappingStoresResponse response) {
            super(context, (Object)response);
        }

        private static ListIdentityMappingStoresPage createEmptyPage() {
            return new ListIdentityMappingStoresPage(null, null);
        }

        protected ListIdentityMappingStoresPage createPage(PageContext<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore> context, ListIdentityMappingStoresResponse response) {
            return new ListIdentityMappingStoresPage(context, response);
        }

        public ApiFuture<ListIdentityMappingStoresPage> createPageAsync(PageContext<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore> context, ApiFuture<ListIdentityMappingStoresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIdentityMappingStoresPagedResponse
    extends AbstractPagedListResponse<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore, ListIdentityMappingStoresPage, ListIdentityMappingStoresFixedSizeCollection> {
        public static ApiFuture<ListIdentityMappingStoresPagedResponse> createAsync(PageContext<ListIdentityMappingStoresRequest, ListIdentityMappingStoresResponse, IdentityMappingStore> context, ApiFuture<ListIdentityMappingStoresResponse> futureResponse) {
            ApiFuture<ListIdentityMappingStoresPage> futurePage = ListIdentityMappingStoresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIdentityMappingStoresPagedResponse((ListIdentityMappingStoresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIdentityMappingStoresPagedResponse(ListIdentityMappingStoresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIdentityMappingStoresFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIdentityMappingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry, ListIdentityMappingsPage, ListIdentityMappingsFixedSizeCollection> {
        private ListIdentityMappingsFixedSizeCollection(List<ListIdentityMappingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIdentityMappingsFixedSizeCollection createEmptyCollection() {
            return new ListIdentityMappingsFixedSizeCollection(null, 0);
        }

        protected ListIdentityMappingsFixedSizeCollection createCollection(List<ListIdentityMappingsPage> pages, int collectionSize) {
            return new ListIdentityMappingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIdentityMappingsPage
    extends AbstractPage<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry, ListIdentityMappingsPage> {
        private ListIdentityMappingsPage(PageContext<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry> context, ListIdentityMappingsResponse response) {
            super(context, (Object)response);
        }

        private static ListIdentityMappingsPage createEmptyPage() {
            return new ListIdentityMappingsPage(null, null);
        }

        protected ListIdentityMappingsPage createPage(PageContext<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry> context, ListIdentityMappingsResponse response) {
            return new ListIdentityMappingsPage(context, response);
        }

        public ApiFuture<ListIdentityMappingsPage> createPageAsync(PageContext<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry> context, ApiFuture<ListIdentityMappingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIdentityMappingsPagedResponse
    extends AbstractPagedListResponse<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry, ListIdentityMappingsPage, ListIdentityMappingsFixedSizeCollection> {
        public static ApiFuture<ListIdentityMappingsPagedResponse> createAsync(PageContext<ListIdentityMappingsRequest, ListIdentityMappingsResponse, IdentityMappingEntry> context, ApiFuture<ListIdentityMappingsResponse> futureResponse) {
            ApiFuture<ListIdentityMappingsPage> futurePage = ListIdentityMappingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIdentityMappingsPagedResponse((ListIdentityMappingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIdentityMappingsPagedResponse(ListIdentityMappingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIdentityMappingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

