/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CmekConfig;
import com.google.cloud.discoveryengine.v1.CmekConfigName;
import com.google.cloud.discoveryengine.v1.CmekConfigServiceSettings;
import com.google.cloud.discoveryengine.v1.DeleteCmekConfigMetadata;
import com.google.cloud.discoveryengine.v1.DeleteCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.GetCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.ListCmekConfigsRequest;
import com.google.cloud.discoveryengine.v1.ListCmekConfigsResponse;
import com.google.cloud.discoveryengine.v1.LocationName;
import com.google.cloud.discoveryengine.v1.UpdateCmekConfigMetadata;
import com.google.cloud.discoveryengine.v1.UpdateCmekConfigRequest;
import com.google.cloud.discoveryengine.v1.stub.CmekConfigServiceStub;
import com.google.cloud.discoveryengine.v1.stub.CmekConfigServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CmekConfigServiceClient
implements BackgroundResource {
    private final CmekConfigServiceSettings settings;
    private final CmekConfigServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CmekConfigServiceClient create() throws IOException {
        return CmekConfigServiceClient.create(CmekConfigServiceSettings.newBuilder().build());
    }

    public static final CmekConfigServiceClient create(CmekConfigServiceSettings settings) throws IOException {
        return new CmekConfigServiceClient(settings);
    }

    public static final CmekConfigServiceClient create(CmekConfigServiceStub stub) {
        return new CmekConfigServiceClient(stub);
    }

    protected CmekConfigServiceClient(CmekConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CmekConfigServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CmekConfigServiceClient(CmekConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CmekConfigServiceSettings getSettings() {
        return this.settings;
    }

    public CmekConfigServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigAsync(CmekConfig config) {
        UpdateCmekConfigRequest request = UpdateCmekConfigRequest.newBuilder().setConfig(config).build();
        return this.updateCmekConfigAsync(request);
    }

    public final OperationFuture<CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigAsync(UpdateCmekConfigRequest request) {
        return this.updateCmekConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCmekConfigRequest, CmekConfig, UpdateCmekConfigMetadata> updateCmekConfigOperationCallable() {
        return this.stub.updateCmekConfigOperationCallable();
    }

    public final UnaryCallable<UpdateCmekConfigRequest, Operation> updateCmekConfigCallable() {
        return this.stub.updateCmekConfigCallable();
    }

    public final CmekConfig getCmekConfig(CmekConfigName name) {
        GetCmekConfigRequest request = GetCmekConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCmekConfig(request);
    }

    public final CmekConfig getCmekConfig(String name) {
        GetCmekConfigRequest request = GetCmekConfigRequest.newBuilder().setName(name).build();
        return this.getCmekConfig(request);
    }

    public final CmekConfig getCmekConfig(GetCmekConfigRequest request) {
        return (CmekConfig)this.getCmekConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetCmekConfigRequest, CmekConfig> getCmekConfigCallable() {
        return this.stub.getCmekConfigCallable();
    }

    public final ListCmekConfigsResponse listCmekConfigs(LocationName parent) {
        ListCmekConfigsRequest request = ListCmekConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCmekConfigs(request);
    }

    public final ListCmekConfigsResponse listCmekConfigs(String parent) {
        ListCmekConfigsRequest request = ListCmekConfigsRequest.newBuilder().setParent(parent).build();
        return this.listCmekConfigs(request);
    }

    public final ListCmekConfigsResponse listCmekConfigs(ListCmekConfigsRequest request) {
        return (ListCmekConfigsResponse)this.listCmekConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<ListCmekConfigsRequest, ListCmekConfigsResponse> listCmekConfigsCallable() {
        return this.stub.listCmekConfigsCallable();
    }

    public final OperationFuture<Empty, DeleteCmekConfigMetadata> deleteCmekConfigAsync(CmekConfigName name) {
        DeleteCmekConfigRequest request = DeleteCmekConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCmekConfigAsync(request);
    }

    public final OperationFuture<Empty, DeleteCmekConfigMetadata> deleteCmekConfigAsync(String name) {
        DeleteCmekConfigRequest request = DeleteCmekConfigRequest.newBuilder().setName(name).build();
        return this.deleteCmekConfigAsync(request);
    }

    public final OperationFuture<Empty, DeleteCmekConfigMetadata> deleteCmekConfigAsync(DeleteCmekConfigRequest request) {
        return this.deleteCmekConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCmekConfigRequest, Empty, DeleteCmekConfigMetadata> deleteCmekConfigOperationCallable() {
        return this.stub.deleteCmekConfigOperationCallable();
    }

    public final UnaryCallable<DeleteCmekConfigRequest, Operation> deleteCmekConfigCallable() {
        return this.stub.deleteCmekConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

