/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CancelTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.CreateTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.GenAiTuningServiceClient;
import com.google.cloud.aiplatform.v1beta1.GetTuningJobRequest;
import com.google.cloud.aiplatform.v1beta1.ListTuningJobsRequest;
import com.google.cloud.aiplatform.v1beta1.ListTuningJobsResponse;
import com.google.cloud.aiplatform.v1beta1.TuningJob;
import com.google.cloud.aiplatform.v1beta1.stub.GenAiTuningServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcGenAiTuningServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class GenAiTuningServiceStubSettings
extends StubSettings<GenAiTuningServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateTuningJobRequest, TuningJob> createTuningJobSettings;
    private final UnaryCallSettings<GetTuningJobRequest, TuningJob> getTuningJobSettings;
    private final PagedCallSettings<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsSettings;
    private final UnaryCallSettings<CancelTuningJobRequest, Empty> cancelTuningJobSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob> LIST_TUNING_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob>(){

        public String emptyToken() {
            return "";
        }

        public ListTuningJobsRequest injectToken(ListTuningJobsRequest payload, String token) {
            return ListTuningJobsRequest.newBuilder((ListTuningJobsRequest)payload).setPageToken(token).build();
        }

        public ListTuningJobsRequest injectPageSize(ListTuningJobsRequest payload, int pageSize) {
            return ListTuningJobsRequest.newBuilder((ListTuningJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTuningJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTuningJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TuningJob> extractResources(ListTuningJobsResponse payload) {
            return payload.getTuningJobsList() == null ? ImmutableList.of() : payload.getTuningJobsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse> LIST_TUNING_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse>(){

        public ApiFuture<GenAiTuningServiceClient.ListTuningJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTuningJobsRequest, ListTuningJobsResponse> callable, ListTuningJobsRequest request, ApiCallContext context, ApiFuture<ListTuningJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TUNING_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GenAiTuningServiceClient.ListTuningJobsPagedResponse.createAsync((PageContext<ListTuningJobsRequest, ListTuningJobsResponse, TuningJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<GenAiTuningServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GenAiTuningServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTuningJobRequest, TuningJob> createTuningJobSettings() {
        return this.createTuningJobSettings;
    }

    public UnaryCallSettings<GetTuningJobRequest, TuningJob> getTuningJobSettings() {
        return this.getTuningJobSettings;
    }

    public PagedCallSettings<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsSettings() {
        return this.listTuningJobsSettings;
    }

    public UnaryCallSettings<CancelTuningJobRequest, Empty> cancelTuningJobSettings() {
        return this.cancelTuningJobSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public GenAiTuningServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGenAiTuningServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GenAiTuningServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GenAiTuningServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GenAiTuningServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTuningJobSettings = settingsBuilder.createTuningJobSettings().build();
        this.getTuningJobSettings = settingsBuilder.getTuningJobSettings().build();
        this.listTuningJobsSettings = settingsBuilder.listTuningJobsSettings().build();
        this.cancelTuningJobSettings = settingsBuilder.cancelTuningJobSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GenAiTuningServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTuningJobRequest, TuningJob> createTuningJobSettings;
        private final UnaryCallSettings.Builder<GetTuningJobRequest, TuningJob> getTuningJobSettings;
        private final PagedCallSettings.Builder<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsSettings;
        private final UnaryCallSettings.Builder<CancelTuningJobRequest, Empty> cancelTuningJobSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTuningJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTuningJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTuningJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TUNING_JOBS_PAGE_STR_FACT);
            this.cancelTuningJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTuningJobSettings, this.getTuningJobSettings, this.listTuningJobsSettings, this.cancelTuningJobSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GenAiTuningServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTuningJobSettings = settings.createTuningJobSettings.toBuilder();
            this.getTuningJobSettings = settings.getTuningJobSettings.toBuilder();
            this.listTuningJobsSettings = settings.listTuningJobsSettings.toBuilder();
            this.cancelTuningJobSettings = settings.cancelTuningJobSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTuningJobSettings, this.getTuningJobSettings, this.listTuningJobsSettings, this.cancelTuningJobSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GenAiTuningServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GenAiTuningServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GenAiTuningServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GenAiTuningServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTuningJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTuningJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTuningJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.cancelTuningJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTuningJobRequest, TuningJob> createTuningJobSettings() {
            return this.createTuningJobSettings;
        }

        public UnaryCallSettings.Builder<GetTuningJobRequest, TuningJob> getTuningJobSettings() {
            return this.getTuningJobSettings;
        }

        public PagedCallSettings.Builder<ListTuningJobsRequest, ListTuningJobsResponse, GenAiTuningServiceClient.ListTuningJobsPagedResponse> listTuningJobsSettings() {
            return this.listTuningJobsSettings;
        }

        public UnaryCallSettings.Builder<CancelTuningJobRequest, Empty> cancelTuningJobSettings() {
            return this.cancelTuningJobSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, GenAiTuningServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public GenAiTuningServiceStubSettings build() throws IOException {
            return new GenAiTuningServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

