/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateReasoningEngineOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.DeleteReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.GetReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.ListReasoningEnginesRequest;
import com.google.cloud.aiplatform.v1beta1.ListReasoningEnginesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngine;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngineName;
import com.google.cloud.aiplatform.v1beta1.ReasoningEngineServiceSettings;
import com.google.cloud.aiplatform.v1beta1.UpdateReasoningEngineOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateReasoningEngineRequest;
import com.google.cloud.aiplatform.v1beta1.stub.ReasoningEngineServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.ReasoningEngineServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ReasoningEngineServiceClient
implements BackgroundResource {
    private final ReasoningEngineServiceSettings settings;
    private final ReasoningEngineServiceStub stub;
    private final OperationsClient operationsClient;

    public static final ReasoningEngineServiceClient create() throws IOException {
        return ReasoningEngineServiceClient.create(ReasoningEngineServiceSettings.newBuilder().build());
    }

    public static final ReasoningEngineServiceClient create(ReasoningEngineServiceSettings settings) throws IOException {
        return new ReasoningEngineServiceClient(settings);
    }

    public static final ReasoningEngineServiceClient create(ReasoningEngineServiceStub stub) {
        return new ReasoningEngineServiceClient(stub);
    }

    protected ReasoningEngineServiceClient(ReasoningEngineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReasoningEngineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected ReasoningEngineServiceClient(ReasoningEngineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ReasoningEngineServiceSettings getSettings() {
        return this.settings;
    }

    public ReasoningEngineServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineAsync(LocationName parent, ReasoningEngine reasoningEngine) {
        CreateReasoningEngineRequest request = CreateReasoningEngineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReasoningEngine(reasoningEngine).build();
        return this.createReasoningEngineAsync(request);
    }

    public final OperationFuture<ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineAsync(String parent, ReasoningEngine reasoningEngine) {
        CreateReasoningEngineRequest request = CreateReasoningEngineRequest.newBuilder().setParent(parent).setReasoningEngine(reasoningEngine).build();
        return this.createReasoningEngineAsync(request);
    }

    public final OperationFuture<ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineAsync(CreateReasoningEngineRequest request) {
        return this.createReasoningEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReasoningEngineRequest, ReasoningEngine, CreateReasoningEngineOperationMetadata> createReasoningEngineOperationCallable() {
        return this.stub.createReasoningEngineOperationCallable();
    }

    public final UnaryCallable<CreateReasoningEngineRequest, Operation> createReasoningEngineCallable() {
        return this.stub.createReasoningEngineCallable();
    }

    public final ReasoningEngine getReasoningEngine(ReasoningEngineName name) {
        GetReasoningEngineRequest request = GetReasoningEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReasoningEngine(request);
    }

    public final ReasoningEngine getReasoningEngine(String name) {
        GetReasoningEngineRequest request = GetReasoningEngineRequest.newBuilder().setName(name).build();
        return this.getReasoningEngine(request);
    }

    public final ReasoningEngine getReasoningEngine(GetReasoningEngineRequest request) {
        return (ReasoningEngine)this.getReasoningEngineCallable().call((Object)request);
    }

    public final UnaryCallable<GetReasoningEngineRequest, ReasoningEngine> getReasoningEngineCallable() {
        return this.stub.getReasoningEngineCallable();
    }

    public final ListReasoningEnginesPagedResponse listReasoningEngines(LocationName parent) {
        ListReasoningEnginesRequest request = ListReasoningEnginesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReasoningEngines(request);
    }

    public final ListReasoningEnginesPagedResponse listReasoningEngines(String parent) {
        ListReasoningEnginesRequest request = ListReasoningEnginesRequest.newBuilder().setParent(parent).build();
        return this.listReasoningEngines(request);
    }

    public final ListReasoningEnginesPagedResponse listReasoningEngines(ListReasoningEnginesRequest request) {
        return (ListReasoningEnginesPagedResponse)((Object)this.listReasoningEnginesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReasoningEnginesRequest, ListReasoningEnginesPagedResponse> listReasoningEnginesPagedCallable() {
        return this.stub.listReasoningEnginesPagedCallable();
    }

    public final UnaryCallable<ListReasoningEnginesRequest, ListReasoningEnginesResponse> listReasoningEnginesCallable() {
        return this.stub.listReasoningEnginesCallable();
    }

    public final OperationFuture<ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineAsync(ReasoningEngine reasoningEngine, FieldMask updateMask) {
        UpdateReasoningEngineRequest request = UpdateReasoningEngineRequest.newBuilder().setReasoningEngine(reasoningEngine).setUpdateMask(updateMask).build();
        return this.updateReasoningEngineAsync(request);
    }

    public final OperationFuture<ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineAsync(UpdateReasoningEngineRequest request) {
        return this.updateReasoningEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateReasoningEngineRequest, ReasoningEngine, UpdateReasoningEngineOperationMetadata> updateReasoningEngineOperationCallable() {
        return this.stub.updateReasoningEngineOperationCallable();
    }

    public final UnaryCallable<UpdateReasoningEngineRequest, Operation> updateReasoningEngineCallable() {
        return this.stub.updateReasoningEngineCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteReasoningEngineAsync(ReasoningEngineName name) {
        DeleteReasoningEngineRequest request = DeleteReasoningEngineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReasoningEngineAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteReasoningEngineAsync(String name) {
        DeleteReasoningEngineRequest request = DeleteReasoningEngineRequest.newBuilder().setName(name).build();
        return this.deleteReasoningEngineAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteReasoningEngineAsync(DeleteReasoningEngineRequest request) {
        return this.deleteReasoningEngineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteReasoningEngineRequest, Empty, DeleteOperationMetadata> deleteReasoningEngineOperationCallable() {
        return this.stub.deleteReasoningEngineOperationCallable();
    }

    public final UnaryCallable<DeleteReasoningEngineRequest, Operation> deleteReasoningEngineCallable() {
        return this.stub.deleteReasoningEngineCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReasoningEnginesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine, ListReasoningEnginesPage, ListReasoningEnginesFixedSizeCollection> {
        private ListReasoningEnginesFixedSizeCollection(List<ListReasoningEnginesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReasoningEnginesFixedSizeCollection createEmptyCollection() {
            return new ListReasoningEnginesFixedSizeCollection(null, 0);
        }

        protected ListReasoningEnginesFixedSizeCollection createCollection(List<ListReasoningEnginesPage> pages, int collectionSize) {
            return new ListReasoningEnginesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReasoningEnginesPage
    extends AbstractPage<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine, ListReasoningEnginesPage> {
        private ListReasoningEnginesPage(PageContext<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine> context, ListReasoningEnginesResponse response) {
            super(context, (Object)response);
        }

        private static ListReasoningEnginesPage createEmptyPage() {
            return new ListReasoningEnginesPage(null, null);
        }

        protected ListReasoningEnginesPage createPage(PageContext<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine> context, ListReasoningEnginesResponse response) {
            return new ListReasoningEnginesPage(context, response);
        }

        public ApiFuture<ListReasoningEnginesPage> createPageAsync(PageContext<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine> context, ApiFuture<ListReasoningEnginesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReasoningEnginesPagedResponse
    extends AbstractPagedListResponse<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine, ListReasoningEnginesPage, ListReasoningEnginesFixedSizeCollection> {
        public static ApiFuture<ListReasoningEnginesPagedResponse> createAsync(PageContext<ListReasoningEnginesRequest, ListReasoningEnginesResponse, ReasoningEngine> context, ApiFuture<ListReasoningEnginesResponse> futureResponse) {
            ApiFuture<ListReasoningEnginesPage> futurePage = ListReasoningEnginesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReasoningEnginesPagedResponse((ListReasoningEnginesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReasoningEnginesPagedResponse(ListReasoningEnginesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReasoningEnginesFixedSizeCollection.createEmptyCollection());
        }
    }
}

