/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.alloydb.AccessTokenSupplier;
import com.google.cloud.alloydb.CredentialFactory;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

class DefaultAccessTokenSupplier
implements AccessTokenSupplier {
    private final CredentialFactory credentialFactory;

    DefaultAccessTokenSupplier(CredentialFactory tokenSource) {
        this.credentialFactory = tokenSource;
    }

    @Override
    public String getTokenValue() throws IOException {
        if (this.credentialFactory == null) {
            return null;
        }
        GoogleCredentials credentials = this.credentialFactory.getCredentials();
        try {
            credentials.refreshIfExpired();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Error refreshing credentials " + credentials, e);
        }
        if (credentials.getAccessToken() == null || "".equals(credentials.getAccessToken().getTokenValue())) {
            String errorMessage = "Access Token has length of zero";
            throw new IllegalStateException(errorMessage);
        }
        this.validateAccessTokenExpiration(credentials.getAccessToken());
        return credentials.getAccessToken().getTokenValue();
    }

    private void validateAccessTokenExpiration(AccessToken accessToken) {
        Instant now;
        Instant expirationTime;
        Date expirationTimeDate = accessToken.getExpirationTime();
        if (expirationTimeDate != null && ((expirationTime = expirationTimeDate.toInstant()).isBefore(now = Instant.now()) || expirationTime.equals(now))) {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.of("UTC"));
            String nowFormat = formatter.format(now);
            String expirationFormat = formatter.format(expirationTime);
            String errorMessage = "Access Token expiration time is in the past. Now = " + nowFormat + " Expiration = " + expirationFormat;
            throw new IllegalStateException(errorMessage);
        }
    }
}

