/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/sessions/{session}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String session;
    private final String collection;
    private final String engine;

    @Deprecated
    protected SessionName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.session = null;
        this.collection = null;
        this.engine = null;
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.collection = null;
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_SESSION;
    }

    private SessionName(ProjectLocationCollectionDataStoreSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION;
    }

    private SessionName(ProjectLocationCollectionEngineSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.dataStore = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_ENGINE_SESSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getSession() {
        return this.session;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreSessionBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreSessionBuilder newProjectLocationCollectionDataStoreSessionBuilder() {
        return new ProjectLocationCollectionDataStoreSessionBuilder();
    }

    public static ProjectLocationCollectionEngineSessionBuilder newProjectLocationCollectionEngineSessionBuilder() {
        return new ProjectLocationCollectionEngineSessionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionName of(String project, String location, String dataStore, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).build();
    }

    public static SessionName ofProjectLocationDataStoreSessionName(String project, String location, String dataStore, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).build();
    }

    public static SessionName ofProjectLocationCollectionDataStoreSessionName(String project, String location, String collection, String dataStore, String session) {
        return SessionName.newProjectLocationCollectionDataStoreSessionBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSession(session).build();
    }

    public static SessionName ofProjectLocationCollectionEngineSessionName(String project, String location, String collection, String engine, String session) {
        return SessionName.newProjectLocationCollectionEngineSessionBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setSession(session).build();
    }

    public static String format(String project, String location, String dataStore, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).build().toString();
    }

    public static String formatProjectLocationDataStoreSessionName(String project, String location, String dataStore, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setSession(session).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreSessionName(String project, String location, String collection, String dataStore, String session) {
        return SessionName.newProjectLocationCollectionDataStoreSessionBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setSession(session).build().toString();
    }

    public static String formatProjectLocationCollectionEngineSessionName(String project, String location, String collection, String engine, String session) {
        return SessionName.newProjectLocationCollectionEngineSessionBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setSession(session).build().toString();
    }

    public static SessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_SESSION.match(formattedString);
            return SessionName.ofProjectLocationDataStoreSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("session"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION.match(formattedString);
            return SessionName.ofProjectLocationCollectionDataStoreSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("session"));
        }
        if (PROJECT_LOCATION_COLLECTION_ENGINE_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE_SESSION.match(formattedString);
            return SessionName.ofProjectLocationCollectionEngineSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"), (String)matchMap.get("session"));
        }
        throw new ValidationException("SessionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionName> parseList(List<String> formattedStrings) {
        ArrayList<SessionName> list = new ArrayList<SessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_SESSION.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_SESSION.matches(formattedString) || PROJECT_LOCATION_COLLECTION_ENGINE_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionName sessionName = this;
            synchronized (sessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SessionName that = (SessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.session, that.session) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class ProjectLocationCollectionEngineSessionBuilder {
        private String project;
        private String location;
        private String collection;
        private String engine;
        private String session;

        protected ProjectLocationCollectionEngineSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectLocationCollectionEngineSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionEngineSessionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionEngineSessionBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionEngineSessionBuilder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public ProjectLocationCollectionEngineSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class ProjectLocationCollectionDataStoreSessionBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String session;

        protected ProjectLocationCollectionDataStoreSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectLocationCollectionDataStoreSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(SessionName sessionName) {
            Preconditions.checkArgument((boolean)Objects.equals(sessionName.pathTemplate, PROJECT_LOCATION_DATA_STORE_SESSION), (Object)"toBuilder is only supported when SessionName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/sessions/{session}");
            this.project = sessionName.project;
            this.location = sessionName.location;
            this.dataStore = sessionName.dataStore;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

