/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReasoningEngineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REASONING_ENGINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reasoningEngine;

    @Deprecated
    protected ReasoningEngineName() {
        this.project = null;
        this.location = null;
        this.reasoningEngine = null;
    }

    private ReasoningEngineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reasoningEngine = (String)Preconditions.checkNotNull((Object)builder.getReasoningEngine());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReasoningEngine() {
        return this.reasoningEngine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReasoningEngineName of(String project, String location, String reasoningEngine) {
        return ReasoningEngineName.newBuilder().setProject(project).setLocation(location).setReasoningEngine(reasoningEngine).build();
    }

    public static String format(String project, String location, String reasoningEngine) {
        return ReasoningEngineName.newBuilder().setProject(project).setLocation(location).setReasoningEngine(reasoningEngine).build().toString();
    }

    public static ReasoningEngineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REASONING_ENGINE.validatedMatch(formattedString, "ReasoningEngineName.parse: formattedString not in valid format");
        return ReasoningEngineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reasoning_engine"));
    }

    public static List<ReasoningEngineName> parseList(List<String> formattedStrings) {
        ArrayList<ReasoningEngineName> list = new ArrayList<ReasoningEngineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReasoningEngineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReasoningEngineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReasoningEngineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REASONING_ENGINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReasoningEngineName reasoningEngineName = this;
            synchronized (reasoningEngineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reasoningEngine != null) {
                        fieldMapBuilder.put((Object)"reasoning_engine", (Object)this.reasoningEngine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REASONING_ENGINE.instantiate(new String[]{"project", this.project, "location", this.location, "reasoning_engine", this.reasoningEngine});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReasoningEngineName that = (ReasoningEngineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reasoningEngine, that.reasoningEngine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reasoningEngine);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reasoningEngine;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReasoningEngine() {
            return this.reasoningEngine;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReasoningEngine(String reasoningEngine) {
            this.reasoningEngine = reasoningEngine;
            return this;
        }

        private Builder(ReasoningEngineName reasoningEngineName) {
            this.project = reasoningEngineName.project;
            this.location = reasoningEngineName.location;
            this.reasoningEngine = reasoningEngineName.reasoningEngine;
        }

        public ReasoningEngineName build() {
            return new ReasoningEngineName(this);
        }
    }
}

