/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatasetVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_DATASET_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String datasetVersion;

    @Deprecated
    protected DatasetVersionName() {
        this.project = null;
        this.location = null;
        this.dataset = null;
        this.datasetVersion = null;
    }

    private DatasetVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.datasetVersion = (String)Preconditions.checkNotNull((Object)builder.getDatasetVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getDatasetVersion() {
        return this.datasetVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatasetVersionName of(String project, String location, String dataset, String datasetVersion) {
        return DatasetVersionName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setDatasetVersion(datasetVersion).build();
    }

    public static String format(String project, String location, String dataset, String datasetVersion) {
        return DatasetVersionName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setDatasetVersion(datasetVersion).build().toString();
    }

    public static DatasetVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_DATASET_VERSION.validatedMatch(formattedString, "DatasetVersionName.parse: formattedString not in valid format");
        return DatasetVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("dataset_version"));
    }

    public static List<DatasetVersionName> parseList(List<String> formattedStrings) {
        ArrayList<DatasetVersionName> list = new ArrayList<DatasetVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatasetVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatasetVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatasetVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_DATASET_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatasetVersionName datasetVersionName = this;
            synchronized (datasetVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.datasetVersion != null) {
                        fieldMapBuilder.put((Object)"dataset_version", (Object)this.datasetVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_DATASET_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "dataset_version", this.datasetVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatasetVersionName that = (DatasetVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.datasetVersion, that.datasetVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.datasetVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String datasetVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getDatasetVersion() {
            return this.datasetVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setDatasetVersion(String datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        private Builder(DatasetVersionName datasetVersionName) {
            this.project = datasetVersionName.project;
            this.location = datasetVersionName.location;
            this.dataset = datasetVersionName.dataset;
            this.datasetVersion = datasetVersionName.datasetVersion;
        }

        public DatasetVersionName build() {
            return new DatasetVersionName(this);
        }
    }
}

