/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PipelineJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PIPELINE_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String pipelineJob;

    @Deprecated
    protected PipelineJobName() {
        this.project = null;
        this.location = null;
        this.pipelineJob = null;
    }

    private PipelineJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.pipelineJob = (String)Preconditions.checkNotNull((Object)builder.getPipelineJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPipelineJob() {
        return this.pipelineJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PipelineJobName of(String project, String location, String pipelineJob) {
        return PipelineJobName.newBuilder().setProject(project).setLocation(location).setPipelineJob(pipelineJob).build();
    }

    public static String format(String project, String location, String pipelineJob) {
        return PipelineJobName.newBuilder().setProject(project).setLocation(location).setPipelineJob(pipelineJob).build().toString();
    }

    public static PipelineJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PIPELINE_JOB.validatedMatch(formattedString, "PipelineJobName.parse: formattedString not in valid format");
        return PipelineJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("pipeline_job"));
    }

    public static List<PipelineJobName> parseList(List<String> formattedStrings) {
        ArrayList<PipelineJobName> list = new ArrayList<PipelineJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PipelineJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PipelineJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PipelineJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PIPELINE_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PipelineJobName pipelineJobName = this;
            synchronized (pipelineJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.pipelineJob != null) {
                        fieldMapBuilder.put((Object)"pipeline_job", (Object)this.pipelineJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PIPELINE_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "pipeline_job", this.pipelineJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PipelineJobName that = (PipelineJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.pipelineJob, that.pipelineJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.pipelineJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String pipelineJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPipelineJob() {
            return this.pipelineJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPipelineJob(String pipelineJob) {
            this.pipelineJob = pipelineJob;
            return this;
        }

        private Builder(PipelineJobName pipelineJobName) {
            this.project = pipelineJobName.project;
            this.location = pipelineJobName.location;
            this.pipelineJob = pipelineJobName.pipelineJob;
        }

        public PipelineJobName build() {
            return new PipelineJobName(this);
        }
    }
}

