/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.monitor.mbean;

import java.beans.ConstructorProperties;
import java.text.DecimalFormat;

public class TempDTO {
    private String dc;
    private String group;
    private String ip;
    private String segment;
    private long sequenceID;
    private String targetDc;
    private boolean messionCompleted;
    private boolean cleanedRebalanceObsData;
    private long howManyRecordsShouldBeRebalancedOut;
    private long howManyRecordsRebalancedIn;
    private long howManyRecordsHasBeenRebalance;
    private String replicationRleaseNum;
    private String replicationNumPerSecond;
    private String database;

    @ConstructorProperties(value={"dc", "group", "ip", "segment", "sequenceID", "messionCompleted", "cleanedRebalanceObsData", "howManyRecordsShouldBeRebalancedOut", "howManyRecordsRebalancedIn", "howManyRecordsHasBeenRebalance"})
    public TempDTO(String dc, String group, String ip, String segment, long sequenceID, boolean messionCompleted, boolean cleanedRebalanceObsData, long howManyRecordsShouldBeRebalancedOut, long howManyRecordsRebalancedIn, long howManyRecordsHasBeenRebalance) {
        this.dc = dc;
        this.group = group;
        this.ip = ip;
        this.segment = segment;
        this.sequenceID = sequenceID;
        this.messionCompleted = messionCompleted;
        this.cleanedRebalanceObsData = cleanedRebalanceObsData;
        this.howManyRecordsShouldBeRebalancedOut = howManyRecordsShouldBeRebalancedOut;
        this.howManyRecordsRebalancedIn = howManyRecordsRebalancedIn;
        this.howManyRecordsHasBeenRebalance = howManyRecordsHasBeenRebalance;
    }

    @ConstructorProperties(value={"dc", "group", "ip", "segment", "sequenceID", "messionCompleted", "targetDc", "cleanedRebalanceObsData", "replicationRleaseNum", "replicationNumPerSecond", "howManyRecordsShouldBeRebalancedOut", "howManyRecordsRebalancedIn", "howManyRecordsHasBeenRebalance", "database"})
    public TempDTO(String dc, String group, String ip, String segment, long sequenceID, boolean messionCompleted, String targetDc, boolean cleanedRebalanceObsData, String replicationRleaseNum, String replicationNumPerSecond, long howManyRecordsShouldBeRebalancedOut, long howManyRecordsRebalancedIn, long howManyRecordsHasBeenRebalance, String database) {
        this.dc = dc;
        this.group = group;
        this.ip = ip;
        this.segment = segment;
        this.sequenceID = sequenceID;
        this.messionCompleted = messionCompleted;
        this.targetDc = targetDc;
        this.cleanedRebalanceObsData = cleanedRebalanceObsData;
        this.replicationNumPerSecond = replicationNumPerSecond;
        this.replicationRleaseNum = replicationRleaseNum;
        this.howManyRecordsShouldBeRebalancedOut = howManyRecordsShouldBeRebalancedOut;
        this.howManyRecordsRebalancedIn = howManyRecordsRebalancedIn;
        this.howManyRecordsHasBeenRebalance = howManyRecordsHasBeenRebalance;
        this.database = database;
    }

    public String getRebalancedRate() {
        if (this.howManyRecordsShouldBeRebalancedOut < 5L || this.howManyRecordsHasBeenRebalance == this.howManyRecordsShouldBeRebalancedOut) {
            return "100%";
        }
        double result = (double)this.howManyRecordsHasBeenRebalance / (double)this.howManyRecordsShouldBeRebalancedOut * 100.0;
        DecimalFormat format = new DecimalFormat("##0.00");
        return format.format(result) + "%";
    }

    public long getReplicationTime() {
        if (this.replicationNumPerSecond == null || this.replicationRleaseNum == null || "0".equals(this.replicationRleaseNum)) {
            return 0L;
        }
        if ("0".equals(this.replicationNumPerSecond)) {
            return -1L;
        }
        long replicationRleaseNums = Long.valueOf(this.replicationRleaseNum);
        long replicationNumPerSeconds = Long.valueOf(this.replicationNumPerSecond);
        return replicationRleaseNums / replicationNumPerSeconds;
    }

    public long getHowManyRecordsShouldBeRebalancedOut() {
        return this.howManyRecordsShouldBeRebalancedOut;
    }

    public void setHowManyRecordsShouldBeRebalancedOut(long howManyRecordsShouldBeRebalancedOut) {
        this.howManyRecordsShouldBeRebalancedOut = howManyRecordsShouldBeRebalancedOut;
    }

    public long getHowManyRecordsRebalancedIn() {
        return this.howManyRecordsRebalancedIn;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setHowManyRecordsRebalancedIn(long howManyRecordsRebalancedIn) {
        this.howManyRecordsRebalancedIn = howManyRecordsRebalancedIn;
    }

    public long getHowManyRecordsHasBeenRebalance() {
        return this.howManyRecordsHasBeenRebalance;
    }

    public void setHowManyRecordsHasBeenRebalance(long howManyRecordsHasBeenRebalance) {
        this.howManyRecordsHasBeenRebalance = howManyRecordsHasBeenRebalance;
    }

    public String getReplicationRleaseNum() {
        return this.replicationRleaseNum;
    }

    public void setReplicationRleaseNum(String replicationRleaseNum) {
        this.replicationRleaseNum = replicationRleaseNum;
    }

    public String getReplicationNumPerSecond() {
        return this.replicationNumPerSecond;
    }

    public void setReplicationNumPerSecond(String replicationNumPerSecond) {
        this.replicationNumPerSecond = replicationNumPerSecond;
    }

    public boolean isCleanedRebalanceObsData() {
        return this.cleanedRebalanceObsData;
    }

    public void setCleanedRebalanceObsData(boolean cleanedRebalanceObsData) {
        this.cleanedRebalanceObsData = cleanedRebalanceObsData;
    }

    public String getTargetDc() {
        return this.targetDc;
    }

    public void setTargetDc(String targetDc) {
        this.targetDc = targetDc;
    }

    public boolean isMessionCompleted() {
        return this.messionCompleted;
    }

    public void setMessionCompleted(boolean messionCompleted) {
        this.messionCompleted = messionCompleted;
    }

    public TempDTO() {
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getSegment() {
        return this.segment;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public long getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(long sequenceID) {
        this.sequenceID = sequenceID;
    }
}

