/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.utils;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConvertUtils.class);

    public static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    public static long bytesToLong(byte[] b) {
        long result = 0L;
        if (b != null) {
            for (int i = 0; i < 8; ++i) {
                result <<= 8;
                result |= (long)(b[i] & 0xFF);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] writeObjectToByte(Object obj) {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("write object to byte error:", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object byteToObj(byte[] bytes) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            logger.error("write byte to object error:", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] serializerProtoStuffBytes(T obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        Schema schema = RuntimeSchema.getSchema(clazz);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)4096);
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, (Schema)schema, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserializedProtoStuff(byte[] bytes, Class<T> clazz, T defaultObj) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Schema schema = RuntimeSchema.getSchema(clazz);
        ProtostuffIOUtil.mergeFrom((byte[])bytes, defaultObj, (Schema)schema);
        return defaultObj;
    }

    public static <T> T deserializedProtoStuff(InputStream is, Class<T> clazz, T defaultObj) throws Exception {
        if (is == null) {
            return null;
        }
        Schema schema = RuntimeSchema.getSchema(clazz);
        ProtostuffIOUtil.mergeFrom((InputStream)is, defaultObj, (Schema)schema);
        return defaultObj;
    }
}

