/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import com.google.inject.Inject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.cassandra.extend.midlayer.utils.Props;
import org.apache.cassandra.extend.midlayer.utils.Utils;
import org.apache.log4j.Logger;

public class SystemPropertiesManager {
    private static Logger logger = Logger.getLogger(SystemPropertiesManager.class);
    private final String systemPropertiesFile = "system_parames.properties";
    private boolean startReplication = false;
    private String zookeeperServers = "";
    private String zookeeperAuthentication = null;
    private int myRelicationOutboundTcpConnections = 1;
    private int replicationCollectionSizeOfOnePath = 0xA00000;
    private int replicationMaxRowNum = 100;
    private int replicationConcurrentFetchingTaskNum = 10;
    private long replicationOverTime = 240000L;
    private int replicationThreadCount = 100;
    private long pingInterval = 60000L;
    private long packetSize = 32L;
    private long allowPacketLossMargin = -1L;
    private long allowTimeMargin = 100L;
    private long availableDetectRPCTimeout = 2000L;
    private int rebalanceCollectionSizeOfOnePath = 0xA00000;
    private int rebalanceMaxRowNum = 100;
    private int rebalanceConcurrentFetchingTaskNum = 3;
    private int maxOfOneSegment = 100000;
    private int serverDemonPort = 7199;
    private int monitorServerPort = 7198;
    private int backupDataHoldDay = 30;
    private int probeport = 8525;
    private String ip = "";
    private String cleanExpireBackupDataTime = "0 0 2 * * ?";
    private String seedNodeConnectToBlobCluster;
    private int intervalOfPerBatchOfRebalanceLogsByRepalyed = 0;

    @Inject
    public SystemPropertiesManager() {
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        Properties properties = Utils.loadPropertiesFileFromClassPath("system_parames.properties");
        Props props = new Props(properties);
        this.set(props);
    }

    private void set(Props props) {
        String startReplicationStr = props.getString("startReplication", "no");
        if ("yes".equals(startReplicationStr)) {
            this.startReplication = true;
        }
        this.zookeeperServers = props.getString("zookeeperServers", "no zookeeper servers url");
        this.zookeeperAuthentication = props.getString("zookeeperAuthentication", null);
        this.replicationCollectionSizeOfOnePath = 0xA00000;
        this.replicationConcurrentFetchingTaskNum = props.getInt("replicationConcurrentFetchingTaskNum", 3);
        this.myRelicationOutboundTcpConnections = 1;
        this.rebalanceCollectionSizeOfOnePath = props.getInt("rebalanceCollectionSizeOfOnePath", 0xA00000);
        this.rebalanceMaxRowNum = props.getInt("rebalanceMaxRowNum", 100);
        this.rebalanceConcurrentFetchingTaskNum = props.getInt("rebalanceConcurrentFetchingTaskNum", 6);
        this.backupDataHoldDay = props.getInt("backupDataHoldDay", 30);
        this.cleanExpireBackupDataTime = props.getString("cleanExpireBackupDataTime", "0 0 2 * * ?");
        this.probeport = props.getInt("probeport", 8525);
        this.ip = props.getString("IP", "");
        String logDir = props.getString("logDir", null);
        if (logDir == null) {
            throw new RuntimeException("you have not set logDir!");
        }
        System.setProperty("logDir", logDir);
        try {
            File logDirFile = new File(logDir);
            if (!logDirFile.exists()) {
                logDirFile.mkdirs();
            }
            File errFile = new File(logDir, "err.log");
            errFile.createNewFile();
            File stdFile = new File(logDir, "std.log");
            stdFile.createNewFile();
            PrintStream errPrintStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(errFile)));
            System.setErr(errPrintStream);
            PrintStream stdPrintStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(stdFile)));
            System.setOut(stdPrintStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.maxOfOneSegment = props.getInt("maxOfOneSegment", 100000);
        this.serverDemonPort = props.getInt("serverDemonPort", 7199);
        this.monitorServerPort = props.getInt("monitorServerPort", 7198);
        this.seedNodeConnectToBlobCluster = props.getString("seedNodeConnectToBlobCluster", null);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean isStartReplication() {
        return this.startReplication;
    }

    public String getZookeeperServers() {
        return this.zookeeperServers;
    }

    public String getZookeeperAuthentication() {
        return this.zookeeperAuthentication;
    }

    public int getMaxOfOneSegment() {
        return this.maxOfOneSegment;
    }

    public int getMyRelicationOutboundTcpConnections() {
        return this.myRelicationOutboundTcpConnections;
    }

    public void setMyRelicationOutboundTcpConnections(int myRelicationOutboundTcpConnections) {
        this.myRelicationOutboundTcpConnections = myRelicationOutboundTcpConnections;
    }

    public int getReplicationCollectionSizeOfOnePath() {
        return this.replicationCollectionSizeOfOnePath;
    }

    public int getRebalanceCollectionSizeOfOnePath() {
        return this.rebalanceCollectionSizeOfOnePath;
    }

    public int getReplicationMaxRowNum() {
        return this.replicationMaxRowNum;
    }

    public int getRebalanceMaxRowNum() {
        return this.rebalanceMaxRowNum;
    }

    public void setReplicationCollectionSizeOfOnePath(int replicationCollectionSizeOfOnePath) {
        this.replicationCollectionSizeOfOnePath = replicationCollectionSizeOfOnePath;
    }

    public void setReplicationMaxRowNum(int replicationMaxRowNum) {
        this.replicationMaxRowNum = replicationMaxRowNum;
    }

    public void setRebalanceCollectionSizeOfOnePath(int rebalanceCollectionSizeOfOnePath) {
        this.rebalanceCollectionSizeOfOnePath = rebalanceCollectionSizeOfOnePath;
    }

    public void setRebalanceMaxRowNum(int rebalanceMaxRowNum) {
        this.rebalanceMaxRowNum = rebalanceMaxRowNum;
    }

    public int getMonitorServerPort() {
        return this.monitorServerPort;
    }

    public int getServerDemonPort() {
        return this.serverDemonPort;
    }

    public int getReplicationConcurrentFetchingTaskNum() {
        return this.replicationConcurrentFetchingTaskNum;
    }

    public int getRebalanceConcurrentFetchingTaskNum() {
        return this.rebalanceConcurrentFetchingTaskNum;
    }

    public void setReplicationConcurrentFetchingTaskNum(int replicationConcurrentFetchingTaskNum) {
        this.replicationConcurrentFetchingTaskNum = replicationConcurrentFetchingTaskNum;
    }

    public void setRebalanceConcurrentFetchingTaskNum(int rebalanceConcurrentFetchingTaskNum) {
        this.rebalanceConcurrentFetchingTaskNum = rebalanceConcurrentFetchingTaskNum;
    }

    public int getBackupDataHoldDay() {
        return this.backupDataHoldDay;
    }

    public String getCleanExpireBackupDataTime() {
        return this.cleanExpireBackupDataTime;
    }

    public int getProbeport() {
        return this.probeport;
    }

    public void setProbeport(int probeport) {
        this.probeport = probeport;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public long getAllowPacketLossMargin() {
        return this.allowPacketLossMargin;
    }

    public void setAllowPacketLossMargin(long allowPacketLossMargin) {
        this.allowPacketLossMargin = allowPacketLossMargin;
    }

    public long getAllowTimeMargin() {
        return this.allowTimeMargin;
    }

    public void setAllowTimeMargin(long allowTimeMargin) {
        this.allowTimeMargin = allowTimeMargin;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(long packetSize) {
        this.packetSize = packetSize;
    }

    public long getAvailableDetectRPCTimeout() {
        return this.availableDetectRPCTimeout;
    }

    public void setAvailableDetectRPCTimeout(long availableDetectRPCTimeout) {
        this.availableDetectRPCTimeout = availableDetectRPCTimeout;
    }

    public long getReplicationOverTime() {
        return this.replicationOverTime;
    }

    public void setReplicationOverTime(long replicationOverTime) {
    }

    public int getReplicationThreadCount() {
        return this.replicationThreadCount;
    }

    public void setReplicationThreadCount(int replicationThreadCount) {
        this.replicationThreadCount = replicationThreadCount;
    }

    public String getSeedNodeConnectToBlobCluster() {
        return this.seedNodeConnectToBlobCluster;
    }

    public int getIntervalOfPerBatchOfRebalanceLogsByRepalyed() {
        return this.intervalOfPerBatchOfRebalanceLogsByRepalyed;
    }

    public void setIntervalOfPerBatchOfRebalanceLogsByRepalyed(int intervalOfPerBatchOfRebalanceLogsByRepalyed) {
        this.intervalOfPerBatchOfRebalanceLogsByRepalyed = intervalOfPerBatchOfRebalanceLogsByRepalyed;
    }
}

