/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import org.apache.cassandra.extend.midlayer.common.BlockIndex;
import org.apache.cassandra.extend.midlayer.common.Constants;
import org.apache.cassandra.thrift.commons.lang.StringUtils;

public class KeyEntity {
    private String fullKey;
    private String bussinessKey;
    private String splitingMete;
    private String version;
    private String lastChunkKey;
    private BlockIndex indexOfSplitingObject;
    private boolean newKey;

    public boolean isNewKey() {
        return this.newKey;
    }

    public KeyEntity(String fullKey) {
        this.fullKey = fullKey;
        String[] keypartitions = StringUtils.split((String)fullKey, (char)'~');
        if (keypartitions.length == 2 && keypartitions[1].length() == 21) {
            this.setBussinessKey(keypartitions[0]);
            this.setSplitingMete(keypartitions[1]);
            this.setVersion(keypartitions[1].substring(1, 20));
            this.setLastChunkKey(keypartitions[1].substring(20));
            this.setIndexOfSplitingObject(new BlockIndex(keypartitions[1].charAt(0), '0', '0'));
            this.newKey = false;
        } else if (keypartitions.length == 2 && keypartitions[1].length() == 23) {
            this.setBussinessKey(keypartitions[0]);
            this.setSplitingMete(keypartitions[1]);
            this.setVersion(keypartitions[1].substring(3, 22));
            this.setLastChunkKey(keypartitions[1].substring(22));
            this.setIndexOfSplitingObject(new BlockIndex(keypartitions[1].charAt(2), keypartitions[1].charAt(1), keypartitions[1].charAt(0)));
            this.newKey = true;
        } else {
            throw new RuntimeException("illegal key:" + fullKey + ",should be purekey~byte3version(clientNanoTime+6random)byte2!");
        }
        try {
            Long.parseLong(keypartitions[1].substring(keypartitions[1].length() - 20, keypartitions[1].length() - 2));
        }
        catch (Exception e) {
            throw new RuntimeException("illegal key:" + fullKey + ",should be purekey~byte3version(clientNanoTime+6random)byte2!");
        }
        Constants.checkGivenLastChunkOrNotFlagIllegal(fullKey.charAt(fullKey.length() - 1));
    }

    public String getFullKey() {
        return this.fullKey;
    }

    public String getBussinessKey() {
        return this.bussinessKey;
    }

    private void setBussinessKey(String bussinessKey) {
        this.bussinessKey = bussinessKey;
    }

    public String getSplitingMete() {
        return this.splitingMete;
    }

    private void setSplitingMete(String splitingMete) {
        this.splitingMete = splitingMete;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    public String getLastChunkKey() {
        return this.lastChunkKey;
    }

    private void setLastChunkKey(String lastChunkKey) {
        this.lastChunkKey = lastChunkKey;
    }

    public BlockIndex getIndexOfSplitingObject() {
        return this.indexOfSplitingObject;
    }

    private void setIndexOfSplitingObject(BlockIndex indexOfSplitingObject) {
        this.indexOfSplitingObject = indexOfSplitingObject;
    }
}

