/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

public class BlockIndex {
    private char[] blockIndexDate = new char[3];
    private static final int BLOCK_INDEX_SIZE = 3;

    public BlockIndex(char ... cs) {
        if (3 != cs.length) {
            throw new RuntimeException("BolbIndex char size is not 3");
        }
        for (int i = 0; i < cs.length; ++i) {
            BlockIndex.checkGivenIndex(cs[i]);
            this.blockIndexDate[i] = cs[i];
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 2; i >= 0; --i) {
            sb.append(this.blockIndexDate[i]);
        }
        return sb.toString();
    }

    public BlockIndex getNextBlockIndex() {
        char[] nextBlob = (char[])this.blockIndexDate.clone();
        for (int i = 0; i < this.blockIndexDate.length; ++i) {
            char nextValidChar;
            if ("zzy".equals(this.toString())) {
                throw new RuntimeException("maxIndexOfSplitedObject:zzy");
            }
            nextBlob[i] = nextValidChar = BlockIndex.getNextValidChar(this.blockIndexDate[i], i);
            if (nextValidChar != '0') break;
        }
        return new BlockIndex(nextBlob);
    }

    public static String getNextIndexOfSplitedByString(String chunkIndex) {
        if (3 != chunkIndex.length()) {
            throw new RuntimeException("BolbIndex String length is not 3 ,chunkIndex String is " + chunkIndex);
        }
        return new BlockIndex(chunkIndex.charAt(2), chunkIndex.charAt(1), chunkIndex.charAt(0)).getNextBlockIndex().toString();
    }

    private static char getNextValidChar(char currentIndexOfSplitedObject, int position) {
        char currentIndexOfSplitedObjectAsInt = currentIndexOfSplitedObject;
        if (currentIndexOfSplitedObjectAsInt >= '0' && currentIndexOfSplitedObjectAsInt < '9') {
            return (char)(currentIndexOfSplitedObjectAsInt + '\u0001');
        }
        if (currentIndexOfSplitedObjectAsInt == '9') {
            return 'A';
        }
        if (currentIndexOfSplitedObjectAsInt >= 'A' && currentIndexOfSplitedObjectAsInt < 'Z') {
            return (char)(currentIndexOfSplitedObjectAsInt + '\u0001');
        }
        if (currentIndexOfSplitedObjectAsInt == 'Z') {
            return 'a';
        }
        if (currentIndexOfSplitedObjectAsInt >= 'a' && currentIndexOfSplitedObjectAsInt < 'z') {
            return (char)(currentIndexOfSplitedObjectAsInt + '\u0001');
        }
        if (currentIndexOfSplitedObjectAsInt == 'z' && position < 2) {
            return '0';
        }
        throw new RuntimeException("illegal currentIndexOfSplitedObject or maxIndexOfSplitedObject:" + currentIndexOfSplitedObject + " at " + position);
    }

    private static void checkGivenIndex(char currentIndexOfSplitedObject) {
        if (!(currentIndexOfSplitedObject >= '0' && currentIndexOfSplitedObject <= '9' || currentIndexOfSplitedObject >= 'A' && currentIndexOfSplitedObject <= 'Z' || currentIndexOfSplitedObject >= 'a' && currentIndexOfSplitedObject <= 'z')) {
            throw new RuntimeException("illegal indexOfSplitedObject:" + currentIndexOfSplitedObject);
        }
    }

    public boolean chunkIndexOfSplitingObjectIsDefault() {
        return "000".equals(this.toString());
    }

    public boolean equals(Object obj) {
        BlockIndex bi;
        if (obj == null) {
            return false;
        }
        return obj instanceof BlockIndex && (bi = (BlockIndex)obj).toString().equals(this.toString());
    }
}

