/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class SimpleCondition
implements Condition {
    boolean set;

    @Override
    public synchronized void await() throws InterruptedException {
        while (!this.set) {
            this.wait();
        }
    }

    public synchronized void reset() {
        this.set = false;
    }

    @Override
    public synchronized boolean await(long time, TimeUnit unit) throws InterruptedException {
        assert (unit == TimeUnit.DAYS || unit == TimeUnit.HOURS || unit == TimeUnit.MINUTES || unit == TimeUnit.SECONDS || unit == TimeUnit.MILLISECONDS);
        long end = System.currentTimeMillis() + unit.convert(time, TimeUnit.MILLISECONDS);
        while (!this.set && end > System.currentTimeMillis()) {
            TimeUnit.MILLISECONDS.timedWait(this, end - System.currentTimeMillis());
        }
        return this.set;
    }

    @Override
    public synchronized void signal() {
        this.set = true;
        this.notify();
    }

    @Override
    public synchronized void signalAll() {
        this.set = true;
        this.notifyAll();
    }

    public synchronized boolean isSignaled() {
        return this.set;
    }

    @Override
    public void awaitUninterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

