/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactoryForClient
implements ThreadFactory {
    protected final String id;
    private final int priority;
    protected final AtomicInteger n = new AtomicInteger(1);

    public NamedThreadFactoryForClient(String id) {
        this(id, 5);
    }

    public NamedThreadFactoryForClient(String id, int priority) {
        this.id = id;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.id + ":" + this.n.getAndIncrement();
        Thread thread = new Thread(runnable, name);
        thread.setPriority(this.priority);
        thread.setDaemon(true);
        return thread;
    }
}

