/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.extend.client.BlobBean;
import org.apache.cassandra.extend.client.FFSClient;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.midlayer.common.BlockIndex;

public class InputStreamFromFFS
extends InputStream {
    private String cfName;
    private String key;
    private byte[] currentChunk = null;
    private boolean isLastChunk = false;
    private String currentChunkIndex;
    private String version = "0000000000000000000";
    private FFSClient ffsClient;
    private int readPosition = 0;

    public InputStreamFromFFS(String cfName, String key, FFSClient ffsClient) {
        this.cfName = cfName;
        this.key = key;
        this.ffsClient = ffsClient;
    }

    @Override
    public int read() throws IOException {
        if (this.currentChunk == null || this.readPosition >= this.currentChunk.length && !this.isLastChunk) {
            this.readPosition = 0;
            this.currentChunkIndex = this.currentChunk == null ? "001" : BlockIndex.getNextIndexOfSplitedByString(this.currentChunkIndex);
            try {
                BlobBean blobBean = this.ffsClient.getOneBlock(this.cfName, this.key, this.currentChunkIndex, this.version);
                if (blobBean.attendLastBlock()) {
                    this.isLastChunk = true;
                }
                this.version = blobBean.getVersion();
                this.currentChunk = blobBean.getBlob();
            }
            catch (FFSException e) {
                throw new IOException(e);
            }
        }
        int ret = this.readPosition >= this.currentChunk.length && this.isLastChunk ? -1 : this.currentChunk[this.readPosition] & 0xFF;
        ++this.readPosition;
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip not supported");
    }
}

