/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.connection.ConnectionManagerListener;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.extend.midlayer.common.PartitionTable;

class FFSNodeStatusConnectionManagerListener
implements ConnectionManagerListener {
    private final PartitionTable partitionTable;

    FFSNodeStatusConnectionManagerListener(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
    }

    public void onHostDown(CassandraHost cassandraHost) {
        if (this.partitionTable != null) {
            PartitionTable.Node status = this.partitionTable.getNodeWithHosts(cassandraHost.getHost());
            if (status == null) {
                throw new HectorException(String.valueOf(100));
            }
            status.setNodeStatus(PartitionTable.Status.invalid);
        }
    }

    public void onHostRestored(CassandraHost cassandraHost) {
        if (this.partitionTable != null) {
            PartitionTable.Node status = this.partitionTable.getNodeWithHosts(cassandraHost.getHost());
            if (status == null) {
                throw new HectorException(String.valueOf(100));
            }
            status.setNodeStatus(PartitionTable.Status.readable);
        }
    }

    public void onAllHostsDown() {
    }

    public void onSuspendHost(CassandraHost cassandraHost, boolean removed) {
    }

    public void onUnSuspendHost(CassandraHost cassandraHost, boolean readded) {
    }

    public void onAddHost(CassandraHost cassandraHost, boolean added, String errorMessage, Exception e) {
        if (this.partitionTable != null) {
            PartitionTable.Node status = this.partitionTable.getNodeWithHosts(cassandraHost.getHost());
            if (status == null) {
                throw new HectorException(String.valueOf(100));
            }
            if (added && PartitionTable.Status.invalid.equals((Object)status.getNodeStatus())) {
                status.setNodeStatus(PartitionTable.Status.readable);
            }
        }
    }

    public void onRemoveHost(CassandraHost cassandraHost, boolean removed, String message) {
    }

    public String getName() {
        return null;
    }
}

