/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.HSuperColumn;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.extend.client.BlobBean;
import org.apache.cassandra.extend.client.Block;
import org.apache.cassandra.extend.client.DataPiece;
import org.apache.cassandra.extend.client.FFSClientCommonModule;
import org.apache.cassandra.extend.client.FFSClientReadModule;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.client.FFSLoadBalancingPolicy;
import org.apache.cassandra.extend.client.UploadingBrokenPoint;
import org.apache.cassandra.extend.midlayer.common.BlockIndex;
import org.apache.cassandra.extend.midlayer.common.Constants;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;
import org.apache.cassandra.thrift.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FFSClientPutModule {
    private static final Log logger = LogFactory.getLog(FFSClientPutModule.class);
    private FFSClientCommonModule commonModule;
    private FFSClientReadModule readModule;
    private Random intRandomAsVersionPartion = new Random(System.currentTimeMillis());
    private int dc = -1;
    static final long initRecordVersion = 0L;
    static final String defalutDigitSign = "defalutDigitSign";

    FFSClientPutModule(FFSClientCommonModule commonModule, FFSClientReadModule readModule) {
        this.commonModule = commonModule;
        this.readModule = readModule;
    }

    public long putBlob(String tableName, String key, InputStream value, Map<String, String> meta, long clock) throws IOException, FFSException {
        DataPiece dataPiece = new DataPiece(value);
        return this.putBlob(tableName, key, dataPiece, meta, clock);
    }

    public long putBlob(String tableName, String key, DataPiece dataPiece, Map<String, String> meta_ori, long clock) throws IOException, FFSException {
        UploadingBrokenPoint uploadingBrokenPoint = this.getUploadingBrokenPoint(tableName, key, dataPiece.getRecordVersion(), dataPiece.getDigitSign());
        long blobSize = uploadingBrokenPoint.getBrokenSize();
        if (blobSize > 0L && dataPiece.getStartPosition() != blobSize) {
            throw new IOException(String.format("startPosition should be %d!", blobSize - 1L));
        }
        long recordVersion = uploadingBrokenPoint.isInit() ? this.getRandomByDCAsVersion() : dataPiece.getRecordVersion();
        dataPiece.writebackRecordVersion(recordVersion);
        String chunkIndex = BlockIndex.getNextIndexOfSplitedByString(uploadingBrokenPoint.getBrokenBlockIndex());
        HashMap<String, String> meta = new HashMap<String, String>();
        if (meta_ori != null) {
            meta.putAll(meta_ori);
        }
        meta.put("ffs_sign", dataPiece.getDigitSign());
        BufferedInputStream valueBufferedInputStream = new BufferedInputStream(dataPiece.getValue());
        while (true) {
            byte[] chunk = this.readOneChunkFromInputStream(valueBufferedInputStream);
            meta.put("ffs_sum", (blobSize += (long)chunk.length) + "");
            if (chunk.length < this.commonModule.getChunkMaxSize() && dataPiece.isLastPiece()) {
                this.putBlob(tableName, key, chunkIndex, 'b', recordVersion, chunk, meta, clock);
                break;
            }
            if (chunk.length == 0) break;
            this.putBlob(tableName, key, chunkIndex, 'a', recordVersion, chunk, meta, clock);
            chunkIndex = BlockIndex.getNextIndexOfSplitedByString(chunkIndex);
        }
        return blobSize;
    }

    public void putBlob(String tableName, String key, byte[] value, Map<String, String> meta, long clock) throws FFSException {
        this.putBlob(tableName, key, "001", 'b', this.getRandomByDCAsVersion(), value, meta, clock);
    }

    UploadingBrokenPoint getUploadingBrokenPoint(String tableName, String key, long recordVersion, String digitSignFromUser) throws FFSException, IOException {
        if (digitSignFromUser == null) {
            throw new FFSException(String.format("digitSign of %s %s should not be null!", tableName, key));
        }
        if (recordVersion == 0L) {
            return new UploadingBrokenPoint("000", 0L);
        }
        Block lastBlock = this.getLastBlockOfSpecialVersion(tableName, key, recordVersion);
        if (lastBlock == null) {
            throw new FFSException(String.format("I can not get uploadingBrokenPoint for record %s %s by recordVersion:%d,please be sure the recordVersion is right!And you could get another init uploadingBrokenPoint by recordVersion=-1!", tableName, key, recordVersion));
        }
        Map<String, String> metas = lastBlock.getMetas();
        String digitSign = metas.get("ffs_sign");
        if (!digitSignFromUser.equals(digitSign)) {
            throw new FFSException(String.format("digitSign of %s %s is diffrent from ffs!", tableName, key));
        }
        String brokenSizeAsStr = metas.get("ffs_sum");
        long brokenSize = 0L;
        if (brokenSizeAsStr != null) {
            brokenSize = Long.parseLong(brokenSizeAsStr);
        }
        UploadingBrokenPoint ret = brokenSize > 0L ? new UploadingBrokenPoint(lastBlock.getBlockIndex(), brokenSize) : new UploadingBrokenPoint("000", 0L);
        return ret;
    }

    private Block getLastBlockOfSpecialVersion(String tableName, String key, long recordVersion) throws FFSException, IOException {
        String blockIndex = "001";
        String preBlockIndex = "000";
        try {
            while (true) {
                this.readModule.getOneBlock(tableName, key, recordVersion + "", blockIndex, new String[]{"timestamp"});
                blockIndex = BlockIndex.getNextIndexOfSplitedByString(blockIndex);
                preBlockIndex = BlockIndex.getNextIndexOfSplitedByString(preBlockIndex);
            }
        }
        catch (FFSException e) {
            if (!this.commonModule.resolveException(e, 106)) {
                throw e;
            }
        }
        catch (IOException e) {
            throw e;
        }
        try {
            BlobBean blobBean = this.readModule.getOneBlock(tableName, key, recordVersion + "", preBlockIndex, new String[]{"meta"});
            return new Block(preBlockIndex, blobBean.getMeta());
        }
        catch (FFSException e) {
            if (!this.commonModule.resolveException(e, 106)) {
                throw e;
            }
            return null;
        }
    }

    void putBlob(String tableName, String bussinessKey, String chunkIndex, char isLastChunk, long recordVersion, byte[] value, Map<String, String> meta, long clock) throws FFSException {
        this.putBlob(tableName, bussinessKey, chunkIndex, isLastChunk, recordVersion, value, null, -1, meta, clock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBlob(String tableName, String bussinessKey, String chunkIndex, char isLastChunk, long recordVersion, byte[] value, String valueMD5, int valueSize, Map<String, String> meta, long clock, boolean updateRecordMetas) throws FFSException {
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Consistency DEBUG  start put blob for %s ~ %s ~ %s ", tableName, bussinessKey, recordVersion + chunkIndex));
        }
        this.commonModule.checkBussinessKey(bussinessKey);
        if (value != null && value.length > this.commonModule.getChunkMaxSize()) {
            throw new FFSException(String.format("your blob is bigger than %d,you should put it by InputStream!", this.commonModule.getChunkMaxSize()));
        }
        if (bussinessKey.indexOf(126) >= 0) {
            throw new FFSException(String.format("there is protected char:%s in you key:%s", Character.valueOf('~'), bussinessKey));
        }
        KeyEntity key = new KeyEntity(bussinessKey + '~' + chunkIndex + recordVersion + isLastChunk);
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            boolean isPutWithClientTime;
            byte[] metaByte;
            Mutator mutator = HFactory.createMutator((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get());
            String metaStr = "";
            if (meta != null) {
                for (String meta_key : meta.keySet()) {
                    String meta_value = meta.get(meta_key) == null ? "" : meta.get(meta_key);
                    if (meta_value.length() == 0) continue;
                    if (meta_key.indexOf(126) >= 0 || meta_value.indexOf(126) >= 0) {
                        throw new FFSException(String.format("there is protected char:%s in you meta:%s", Character.valueOf('~'), key.getFullKey()));
                    }
                    metaStr = metaStr + "~~" + meta_key + '~' + meta_value;
                }
            }
            metaStr = metaStr + "~~ffs_s~" + (value == null ? valueSize : value.length);
            metaStr = metaStr + "~~ffs_v~" + recordVersion;
            if (valueMD5 != null) {
                metaStr = metaStr + "~~meta_ffs_blob_MD5_name~" + valueMD5;
            }
            if ((metaByte = (metaStr = metaStr.substring("~~".length())).getBytes(Constants.UTF_8)).length > 4096) {
                throw new FFSException(String.format("meta length is more than %d bytes!", 4096));
            }
            HColumn column_filename = HFactory.createColumn((Object)"meta", (Object)metaByte, (long)clock, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
            ArrayList<HColumn> superColumn_value = new ArrayList<HColumn>();
            superColumn_value.add(column_filename);
            if (value != null) {
                HColumn column_blob = HFactory.createColumn((Object)"blob", (Object)value, (long)clock, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                superColumn_value.add(column_blob);
            } else if (updateRecordMetas && valueSize == 0 && "d41d8cd98f00b204e9800998ecf8427e".equals(valueMD5) && "zzy".equals(chunkIndex)) {
                HColumn column_update_properties = HFactory.createColumn((Object)"VALUE_UPDATE_RECORD_PROPERTIES_STR", (Object)Constants.VALUE_UPDATE_RECORD_PROPERTIES.array(), (long)clock, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                superColumn_value.add(column_update_properties);
            }
            boolean bl = isPutWithClientTime = clock > 1L;
            if (isPutWithClientTime) {
                HColumn column_put_with_time_flag = HFactory.createColumn((Object)"putWithClientTime", (Object)BooleanUtils.toStringTrueFalse((boolean)isPutWithClientTime).getBytes(), (long)clock, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                superColumn_value.add(column_put_with_time_flag);
            }
            HSuperColumn superColumn = HFactory.createSuperColumn((Object)"values", superColumn_value, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
            mutator.addInsertion((Object)key.getFullKey(), tableName, superColumn);
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.WRITE);
                mutator.execute();
            }
            catch (Exception e) {
                block20: {
                    try {
                        String errorMsg = this.commonModule.dealOperationException(e, tableName, key, i);
                        if (i != tryNum - 1) break block20;
                        throw new FFSException(errorMsg, e);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Consistency DEBUG  end put blob for %s ~ %s ~ %s,spend Time:%d ms", tableName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
                        }
                        this.commonModule.removeCurrentLoadBalanceRequestBean();
                        throw throwable;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Consistency DEBUG  end put blob for %s ~ %s ~ %s,spend Time:%d ms", tableName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
                }
                this.commonModule.removeCurrentLoadBalanceRequestBean();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Consistency DEBUG  end put blob for %s ~ %s ~ %s,spend Time:%d ms", tableName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
            }
            this.commonModule.removeCurrentLoadBalanceRequestBean();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flashback(String tableName, String bussinessKey, long beforeWhichTime) throws FFSException {
        KeyEntity key = new KeyEntity(bussinessKey + '~' + "001" + "0000000000000000000" + 'b');
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            HColumn column_blob = HFactory.createColumn((Object)"FLASH_BACK", (Object)ByteBufferUtil.bytes(beforeWhichTime).array(), (long)beforeWhichTime, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
            ArrayList<HColumn> superColumn_value = new ArrayList<HColumn>();
            superColumn_value.add(column_blob);
            HSuperColumn superColumn = HFactory.createSuperColumn((Object)"values", superColumn_value, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
            Mutator mutator = HFactory.createMutator((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get());
            mutator.addInsertion((Object)key.getFullKey(), tableName, superColumn);
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.WRITE);
                mutator.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.commonModule.dealOperationException(e, tableName, key, i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.commonModule.removeCurrentLoadBalanceRequestBean();
            }
        }
    }

    private long getRandomByDCAsVersion() throws FFSException {
        this.tryToInitDC();
        return System.currentTimeMillis() * 1000000L + (long)(this.dc * 100000) + (long)this.intRandomAsVersionPartion.nextInt(100000);
    }

    private void tryToInitDC() throws FFSException {
        try {
            if (this.dc == -1) {
                this.dc = this.commonModule.getDCNameConnected();
            }
        }
        catch (Exception e) {
            throw new FFSException(e);
        }
        if (this.dc == -1) {
            throw new FFSException("can not get dc name!");
        }
    }

    private byte[] readOneChunkFromInputStream(BufferedInputStream value) throws IOException {
        int remainingSize;
        int unitSize;
        byte[] readUnit;
        int bytesGot;
        int fixUnitSize = 262144;
        ArrayList<byte[]> unitSet = new ArrayList<byte[]>();
        int chunkSize = 0;
        while ((bytesGot = value.read(readUnit = new byte[unitSize = Math.min(remainingSize = this.commonModule.getChunkMaxSize() - chunkSize, fixUnitSize)])) != -1) {
            if (bytesGot < unitSize) {
                unitSet.add(Arrays.copyOf(readUnit, bytesGot));
            } else {
                unitSet.add(readUnit);
            }
            if ((chunkSize += bytesGot) < this.commonModule.getChunkMaxSize()) continue;
            break;
        }
        byte[] ret = new byte[chunkSize];
        int desPos = 0;
        for (int i = 0; i < unitSet.size(); ++i) {
            System.arraycopy(unitSet.get(i), 0, ret, desPos, ((byte[])unitSet.get(i)).length);
            desPos += ((byte[])unitSet.get(i)).length;
        }
        return ret;
    }

    public void updateRecordProteties(String tableName, String bussinessKey, Map<String, String> meta, long clock) throws FFSException {
        long recordVersion = this.getRandomByDCAsVersion();
        this.putBlob(tableName, bussinessKey, "zzy", 'b', recordVersion, null, "d41d8cd98f00b204e9800998ecf8427e", 0, meta, clock, true);
    }

    public boolean tryToPutWithOutTransBlobs(String tableName, String key, List<String> blobMD5s, Map<String, String> meta_ori, long clock) throws IOException, FFSException {
        long recordVersion = this.getRandomByDCAsVersion();
        String chunkIndex = BlockIndex.getNextIndexOfSplitedByString("000");
        HashMap<String, String> meta = new HashMap<String, String>();
        if (meta_ori != null) {
            meta.putAll(meta_ori);
        }
        ArrayList<Integer> blobSizes = new ArrayList<Integer>();
        for (String blobMD5 : blobMD5s) {
            Integer blobSize = this.readModule.getBlobSize(tableName, blobMD5);
            if (blobSize < 0) {
                return false;
            }
            blobSizes.add(blobSize);
        }
        for (int i = 0; i < blobMD5s.size(); ++i) {
            this.putBlob(tableName, key, chunkIndex, i == blobMD5s.size() - 1 ? (char)'b' : 'a', recordVersion, null, blobMD5s.get(i), (Integer)blobSizes.get(i), meta, clock, false);
            chunkIndex = BlockIndex.getNextIndexOfSplitedByString(chunkIndex);
        }
        return true;
    }
}

