/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.extend.client.FFSClientCommonModule;
import org.apache.cassandra.extend.client.SimpleCondition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFSClientExecuteHandler
implements Runnable {
    private final SimpleCondition sc = new SimpleCondition();
    private static Log logger = LogFactory.getLog(FFSClientExecuteHandler.class);
    private FFSClientCommonModule commonModule;
    private String fromTableName;
    private String key;
    private String toDataBase;
    private String toTableName;
    private boolean isDeleteSourceData = true;
    private boolean isOperateSucc;
    private long startTime;
    private long timeout = 60000L;

    public FFSClientExecuteHandler(FFSClientCommonModule commonModule, String fromTableName, String key, String toDataBase, String toTableName, boolean isDeleteSourceData) {
        this.commonModule = commonModule;
        this.fromTableName = fromTableName;
        this.key = key;
        this.toDataBase = toDataBase;
        this.toTableName = toTableName;
        this.isDeleteSourceData = isDeleteSourceData;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.commonModule.copyOrCutDataToOtherTable(this.fromTableName, this.key, this.toDataBase, this.toTableName, this.isDeleteSourceData);
            this.isOperateSucc = true;
        }
        catch (Exception e) {
            this.isOperateSucc = false;
            logger.error((Object)("batchCopyOrCutRecordToOtherTable had happen a error by key:" + this.key), (Throwable)e);
        }
        finally {
            this.sc.signal();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isOperateSucc() {
        return this.isOperateSucc;
    }

    public void setOperateSucc(boolean isOperateSucc) {
        this.isOperateSucc = isOperateSucc;
    }

    public void get() throws TimeoutException {
        boolean success;
        try {
            long time = this.timeout - (System.currentTimeMillis() - this.startTime);
            success = this.sc.await(time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)"wait Thread error", (Throwable)e);
            success = false;
        }
        if (!success) {
            throw new TimeoutException();
        }
    }
}

