/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import org.apache.cassandra.extend.client.FFSClientCommonModule;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.client.FFSLoadBalancingPolicy;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FFSClientDeleteModule {
    private static final Log logger = LogFactory.getLog(FFSClientDeleteModule.class);
    private FFSClientCommonModule commonModule;

    FFSClientDeleteModule(FFSClientCommonModule commonModule) {
        this.commonModule = commonModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String cfName, String bussinessKey, long clock) throws FFSException {
        long startTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Consistency DEBUG  start delete blob for %s ~ %s ", cfName, bussinessKey));
        }
        this.commonModule.checkBussinessKey(bussinessKey);
        KeyEntity key = new KeyEntity(bussinessKey + '~' + "000" + "0000000000000000000" + 'b');
        Mutator mutator = HFactory.createMutator((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get());
        mutator.addDeletion((Object)key.getFullKey(), cfName, clock);
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.WRITE);
                mutator.execute();
            }
            catch (Exception e) {
                block9: {
                    try {
                        String errorMsg = this.commonModule.dealOperationException(e, cfName, key, i);
                        if (i != tryNum - 1) break block9;
                        throw new FFSException(errorMsg, e);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Consistency DEBUG  end delete blob for %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, System.currentTimeMillis() - startTime));
                        }
                        this.commonModule.removeCurrentLoadBalanceRequestBean();
                        throw throwable;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Consistency DEBUG  end delete blob for %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, System.currentTimeMillis() - startTime));
                }
                this.commonModule.removeCurrentLoadBalanceRequestBean();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Consistency DEBUG  end delete blob for %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, System.currentTimeMillis() - startTime));
            }
            this.commonModule.removeCurrentLoadBalanceRequestBean();
            break;
        }
    }
}

