/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.cassandra.service.CassandraHost;
import hector.me.prettyprint.hector.api.Cluster;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.ColumnSlice;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.HSuperColumn;
import hector.me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import hector.me.prettyprint.hector.api.exceptions.HTimedOutException;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.mutation.Mutator;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.SliceQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.client.FFSLoadBalancingPolicy;
import org.apache.cassandra.extend.midlayer.common.ErrorCodeConstants;
import org.apache.cassandra.extend.midlayer.common.FFSCalculatePartitionIdUtils;
import org.apache.cassandra.extend.midlayer.common.FFSSerializableSerializer;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.cassandra.extend.midlayer.common.PartitionTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFSClientCommonModule {
    private static final Log log = LogFactory.getLog(FFSClientCommonModule.class);
    public static final String metasSplitor = "~~";
    public static final String meta_version_name = "ffs_v";
    public static final String meta_size_name = "ffs_s";
    public static final String meta_sumsize_name = "ffs_sum";
    public static final String meta_digitsign_name = "ffs_sign";
    public static final String meta_blob_MD5_name = "meta_ffs_blob_MD5_name";
    public static final String defalutDigitSign = "defalutDigitSign";
    private static final Set<String> meta_names_protected = new HashSet<String>();
    private int chunkMaxSize = 0x200000;
    private Keyspace keyspace = null;
    private final Cluster cluster;
    private final PartitionTable partitionTable;
    private static final int DEF_AUTO_DISCOVERY_DELAY = 30;
    private final FFSLoadBalancingPolicy policy;
    private final String defaultHost;

    public static Set<String> getMetaNamsProtected() {
        return new HashSet<String>(meta_names_protected);
    }

    FFSClientCommonModule(Keyspace keyspace, int chunkMaxSize, Cluster cluster, PartitionTable partitionTable, FFSLoadBalancingPolicy policy, String defaultHosts) {
        this.keyspace = keyspace;
        this.chunkMaxSize = chunkMaxSize;
        this.cluster = cluster;
        this.partitionTable = partitionTable;
        this.policy = policy;
        this.defaultHost = defaultHosts.trim().split(":")[0];
    }

    void shutdown() {
        this.cluster.getConnectionManager().shutdown();
    }

    void releaseIdleConnections() {
        this.cluster.getConnectionManager().releaseIdleClientsForAllHostPools();
    }

    void addLoadBalanceRequestBean(KeyEntity key, FFSLoadBalancingPolicy.OperationType type) {
    }

    FFSLoadBalancingPolicy.LoadBalanceRequestBean removeCurrentLoadBalanceRequestBean() {
        return this.policy.removeThreadSafedOperateKey();
    }

    int getChunkMaxSize() {
        return this.chunkMaxSize;
    }

    Keyspace getKeyspace() {
        return this.keyspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean copyOrCutDataToOtherTable(String fromTableName, String key, String toDataBase, String toTableName, boolean isDeleteSourceData) throws FFSException {
        int tryNum = 3;
        KeyEntity bussinessKey = new KeyEntity(key + '~' + "000" + "0000000000000000000" + 'b');
        for (int i = 0; i < tryNum; ++i) {
            try {
                Mutator mutator = HFactory.createMutator((Keyspace)this.getKeyspace(), (Serializer)StringSerializer.get());
                ArrayList<HColumn> superColumn_value = new ArrayList<HColumn>();
                HColumn column_filename = HFactory.createColumn((Object)(isDeleteSourceData ? "CUT_RECORD" : "COPY_RECORD"), (Object)(toDataBase + '~' + toTableName).getBytes(), (int)100, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                this.addLoadBalanceRequestBean(bussinessKey, FFSLoadBalancingPolicy.OperationType.WRITE);
                superColumn_value.add(column_filename);
                HSuperColumn superColumn = HFactory.createSuperColumn((Object)"values", superColumn_value, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                mutator.addInsertion((Object)(key + '~' + "000" + "0000000000000000000" + 'a'), fromTableName, superColumn);
                mutator.execute();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                if (i == tryNum - 1) {
                    throw new FFSException(e);
                }
                this.dealOperationException(e, fromTableName, bussinessKey, i);
                continue;
            }
            finally {
                this.removeCurrentLoadBalanceRequestBean();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDCNameConnected() throws FFSException {
        int tryNum = 5;
        for (int i = 0; i < tryNum; ++i) {
            block9: {
                SliceQuery sliceQuery = this.createSliceQuery((Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
                sliceQuery.setKey((Object)"0~0000000000000000000000a").setColumnFamily("SYSTEM_TABLE_NAME_USED_BY_CLIENT").setColumnNames((Object[])new String[]{"DC_NAME"});
                this.addLoadBalanceRequestBean(null, FFSLoadBalancingPolicy.OperationType.READ);
                QueryResult queryResult = sliceQuery.execute();
                ColumnSlice columnSlice = (ColumnSlice)queryResult.get();
                Iterator iterator = columnSlice.getColumns().iterator();
                if (!iterator.hasNext()) break block9;
                HColumn dcColumn = (HColumn)iterator.next();
                int n = Integer.valueOf((String)dcColumn.getValue());
                this.removeCurrentLoadBalanceRequestBean();
                return n;
            }
            try {
                try {
                    throw new FFSException("can not get dc name!");
                }
                catch (Exception e) {
                    if (i == tryNum - 1) {
                        throw new FFSException(e);
                    }
                    log.warn((Object)("ffs client execute error,tryNum=" + i + ",and exception:"), (Throwable)e);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    this.removeCurrentLoadBalanceRequestBean();
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.removeCurrentLoadBalanceRequestBean();
                throw throwable;
            }
        }
        throw new FFSException("can not get dc name!");
    }

    void initPartitionTable() throws FFSException {
        block7: {
            try {
                SliceQuery sliceQuery = this.createSliceQuery((Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
                sliceQuery.setKey((Object)"0~0000000000000000000000a").setColumnFamily("SYSTEM_TABLE_NAME_USED_BY_CLIENT").setColumnNames((Object[])new String[]{"PARTITION_TABLE"});
                this.addLoadBalanceRequestBean(null, FFSLoadBalancingPolicy.OperationType.READ);
                QueryResult queryResult = sliceQuery.execute();
                ColumnSlice columnSlice = (ColumnSlice)queryResult.get();
                Iterator iterator = columnSlice.getColumns().iterator();
                if (iterator.hasNext()) {
                    HColumn dcColumn = (HColumn)iterator.next();
                    PartitionTable initpartitionTable = (PartitionTable)FFSSerializableSerializer.deserialize((byte[])dcColumn.getValue());
                    this.partitionTable.flushPartitionTables(initpartitionTable);
                    for (PartitionTable.Node node : this.partitionTable.getAllPartitionTableHost()) {
                        int port = ((CassandraHost)this.cluster.getKnownPoolHosts(true).iterator().next()).getPort();
                        this.cluster.addHost(new CassandraHost(node.getHostAddress(), port), true);
                    }
                    break block7;
                }
                throw new FFSException("can not get dc name!");
            }
            catch (Exception e) {
                throw new FFSException(e);
            }
            finally {
                this.removeCurrentLoadBalanceRequestBean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forceReplicateData(String table, String bussinessKey) throws FFSException {
        ColumnSlice columnSlice;
        Iterator iterator;
        KeyEntity key = new KeyEntity(bussinessKey + '~' + "001" + "0000000000000000000" + 'b');
        SliceQuery sliceQuery = this.createSliceQuery((Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        sliceQuery.setKey((Object)key.getFullKey()).setColumnFamily("SYSTEM_TABLE_NAME_USED_BY_CLIENT").setColumnNames((Object[])new String[]{"FOCUS_REPLICATE~" + table});
        QueryResult queryResult = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.READ);
                queryResult = sliceQuery.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.dealOperationException(e, table, key, i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.removeCurrentLoadBalanceRequestBean();
            }
        }
        if ((iterator = (columnSlice = (ColumnSlice)queryResult.get()).getColumns().iterator()).hasNext()) {
            HColumn column = (HColumn)iterator.next();
            return Boolean.valueOf((String)column.getValue());
        }
        return false;
    }

    void toggleWritableNode(KeyEntity key) {
        if (!this.partitionTable.isEmpty()) {
            String partitionId = FFSCalculatePartitionIdUtils.calculatePartitionId(key);
            List<PartitionTable.Node> partitionNodes = this.partitionTable.getValidNode(this.removeCurrentLoadBalanceRequestBean().getDc(), partitionId);
            for (PartitionTable.Node status : partitionNodes) {
                if (PartitionTable.Status.readable.equals((Object)status.getNodeStatus())) {
                    status.setNodeStatus(PartitionTable.Status.writable);
                    continue;
                }
                if (!PartitionTable.Status.writable.equals((Object)status.getNodeStatus())) continue;
                status.setNodeStatus(PartitionTable.Status.readable);
            }
        }
    }

    boolean resolveException(Exception e, int errorCode) {
        if (e instanceof HInvalidRequestException) {
            String errorMessage = ((HInvalidRequestException)e).getWhy();
            String[] errorMessages = errorMessage.split("::");
            if (errorMessage.contains(errorCode + "::") || ErrorCodeConstants.isValidErrorCode(errorMessage) && errorMessages[0].equals(String.valueOf(errorCode))) {
                return true;
            }
        } else if (e.getCause() instanceof HInvalidRequestException) {
            String errorMessage = ((HInvalidRequestException)e.getCause()).getWhy();
            String[] errorMessages = errorMessage.split("::");
            if (errorMessage.contains(errorCode + "::") || ErrorCodeConstants.isValidErrorCode(errorMessage) && errorMessages[0].equals(String.valueOf(errorCode))) {
                return true;
            }
        }
        return false;
    }

    String dealOperationException(Exception e, String table, KeyEntity key, int i) throws FFSException {
        String errorMsg = String.format("client operation %s~%s~%s error ", this.keyspace.getKeyspaceName(), table, key.getFullKey());
        if (this.resolveException(e, 106)) {
            log.warn((Object)(errorMsg + " not exist!"));
            throw new FFSException(errorMsg, e);
        }
        if (this.resolveException(e, 101)) {
            log.warn((Object)(errorMsg + "deal operation need retry,cased by CANNOT_ACCEPT_WRITE_ERROR for ffs server,tryNum=" + i), (Throwable)e);
            try {
                Thread.sleep((long)i * 500L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            return errorMsg;
        }
        if (this.resolveException(e, 100)) {
            log.warn((Object)(errorMsg + "deal operation need retry,cased by MISS_PARTITION_ERROR for ffs server,tryNum=" + i), (Throwable)e);
            try {
                Thread.sleep((long)i * 500L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            return errorMsg;
        }
        if (this.isNeedRetryException(e)) {
            log.warn((Object)(errorMsg + "deal operation need retry,cased by  retry exception from ffs server,tryNum=" + i), (Throwable)e);
            return errorMsg;
        }
        if (this.resolveException(e, 999) || e.getMessage().contains(". Retry burden pushed out to client.") || e instanceof HTimedOutException) {
            log.warn((Object)(errorMsg + "deal operation need retry,tryNum=" + i), (Throwable)e);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            return errorMsg;
        }
        log.warn((Object)errorMsg, (Throwable)e);
        return errorMsg;
    }

    private boolean isNeedRetryException(Exception e) {
        String errorMessage;
        return e instanceof HInvalidRequestException ? ErrorCodeConstants.isValidRetryErrorCode(errorMessage = ((HInvalidRequestException)e).getWhy()) : ErrorCodeConstants.isValidRetryErrorCode(e.getMessage());
    }

    protected <K, N, V> SliceQuery<K, N, V> createSliceQuery(Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        return HFactory.createSliceQuery((Keyspace)this.keyspace, keySerializer, nameSerializer, valueSerializer);
    }

    void checkBussinessKey(String bussinessKey) {
        if (bussinessKey == null || bussinessKey.trim().equals("")) {
            throw new RuntimeException("bussinessKey can not be empty");
        }
    }

    static {
        meta_names_protected.add(meta_version_name);
        meta_names_protected.add(meta_size_name);
        meta_names_protected.add(meta_sumsize_name);
        meta_names_protected.add(meta_digitsign_name);
        meta_names_protected.add(meta_blob_MD5_name);
    }
}

