/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.io.InputStream;

public class DataPiece {
    private long totalSize;
    private long recordVersion;
    private String digitSign;
    private InputStream value;
    private long startPosition;
    private long endPosition;

    public DataPiece(long recordVersion, String digitSign, long totalSize, InputStream value, long startPosition, long endPosition) {
        if (recordVersion == 0L && startPosition > 0L) {
            throw new RuntimeException(String.format("startPosition must be 0 when recordVersion is %d!", 0L));
        }
        if (startPosition > endPosition) {
            throw new RuntimeException(String.format("startPosition must be less than endPosition!", new Object[0]));
        }
        if (endPosition >= totalSize) {
            throw new RuntimeException(String.format("endPosition must be less than totalSize!", new Object[0]));
        }
        if (digitSign == null || digitSign.length() == 0) {
            throw new RuntimeException(String.format("digitSign should not be null or empty!", new Object[0]));
        }
        this.recordVersion = recordVersion;
        this.digitSign = digitSign;
        this.totalSize = totalSize;
        this.value = value;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public DataPiece(long recordVersion, long totalSize, InputStream value, long startPosition, long endPosition) {
        this(recordVersion, "defalutDigitSign", totalSize, value, startPosition, endPosition);
    }

    public DataPiece(String digitSign, long totalSize, InputStream value, long startPosition, long endPosition) {
        this(0L, digitSign, totalSize, value, startPosition, endPosition);
    }

    public DataPiece(long totalSize, InputStream value, long startPosition, long endPosition) {
        this(0L, "defalutDigitSign", totalSize, value, startPosition, endPosition);
    }

    DataPiece(InputStream value) {
        this("defalutDigitSign", 1L, value, 0L, 0L);
    }

    void writebackRecordVersion(long recordVersion) {
        this.recordVersion = recordVersion;
    }

    public long getRecordVersion() {
        return this.recordVersion;
    }

    public String getDigitSign() {
        return this.digitSign;
    }

    public InputStream getValue() {
        return this.value;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public boolean isLastPiece() {
        return this.totalSize == this.endPosition + 1L;
    }
}

