/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.extend.client.FFSClientCommonModule;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.midlayer.common.ClientContants;

public class BlobBean {
    private long timestamp;
    private Map<String, String> meta = new HashMap<String, String>();
    private OutputStream blobOS = null;
    private List<byte[]> blobs = new ArrayList<byte[]>();
    private ByteBuffer lastChunkFlag = null;
    private long sumSizeOfCurrentContent;
    private String version;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public BlobBean(OutputStream blobOS) {
        this.blobOS = blobOS;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public void addBlob(byte[] blob) throws IOException {
        this.sumSizeOfCurrentContent += (long)blob.length;
        if (this.blobOS == null) {
            this.blobs.add(blob);
        } else {
            this.blobOS.write(blob);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public Map<String, String> getBlobMetaWithoutProtectedAttribute() {
        Set<String> metaNamsProtected = FFSClientCommonModule.getMetaNamsProtected();
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            if (metaNamsProtected.contains(entry.getKey())) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public byte[] getBlob() throws FFSException {
        if (this.blobOS == null) {
            if (this.blobs.size() == 1) {
                return this.blobs.get(0);
            }
            int blobTotalSize = 0;
            for (int i = 0; i < this.blobs.size(); ++i) {
                blobTotalSize += this.blobs.get(i).length;
            }
            byte[] ret = new byte[blobTotalSize];
            int desPos = 0;
            for (int i = 0; i < this.blobs.size(); ++i) {
                System.arraycopy(this.blobs.get(i), 0, ret, desPos, this.blobs.get(i).length);
                desPos += this.blobs.get(i).length;
            }
            return ret;
        }
        throw new FFSException("you should got blob from OutputStream src!");
    }

    public void setLastChunkFlag(ByteBuffer lastChunkFlag) {
        this.lastChunkFlag = lastChunkFlag;
    }

    public boolean attendLastBlock() {
        return ClientContants.LAST_CHUNK_OF_SPLITED_OBJECT_AS_BYTEBUFFER.equals(this.lastChunkFlag);
    }

    public long getSumSizeOfCurrentContent() {
        return this.sumSizeOfCurrentContent;
    }
}

