/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BytePictureUtils {
    private static Logger logger = LoggerFactory.getLogger(BytePictureUtils.class);

    public static byte[] getUrlByteArray(String urlPath) {
        try {
            return BytePictureUtils.toByteArray(BytePictureUtils.getUrlPictureStream(urlPath));
        }
        catch (IOException e) {
            logger.error("getUrlPictureStream error,{},{}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static byte[] getLocalByteArray(File res) {
        try {
            return BytePictureUtils.toByteArray(new FileInputStream(res));
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
            return null;
        }
    }

    public static byte[] getBufferByteArray(BufferedImage image) {
        return BytePictureUtils.getBufferByteArray(image, null);
    }

    public static byte[] getBufferByteArray(BufferedImage image, String format) {
        String formatName;
        String string = formatName = StringUtils.isNotEmpty((CharSequence)format) && format.charAt(0) == '.' ? format.substring(1) : format;
        if (StringUtils.isEmpty((CharSequence)formatName)) {
            formatName = "png";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, formatName, os);
        }
        catch (IOException e) {
            logger.error("getBufferByteArray error", (Throwable)e);
        }
        return os.toByteArray();
    }

    public static byte[] toByteArray(InputStream is) {
        if (null == is) {
            return null;
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            logger.error("toByteArray error", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("close stream error", (Throwable)e);
            }
        }
        return null;
    }

    public static BufferedImage getUrlBufferedImage(String urlPath) {
        URL url = null;
        BufferedImage bufferImage = null;
        try {
            url = new URL(urlPath);
            bufferImage = ImageIO.read(url);
            return bufferImage;
        }
        catch (Exception e) {
            logger.error("getUrlBufferedImage error, {}, {}", (Object)urlPath, (Object)e);
            return null;
        }
    }

    public static BufferedImage getLocalBufferedImage(File res) {
        try {
            BufferedImage read = ImageIO.read(res);
            return read;
        }
        catch (FileNotFoundException e) {
            logger.error("FileNotFound", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("getLocalBufferedImage IO error", (Throwable)e);
        }
        return null;
    }

    public static InputStream getUrlPictureStream(String urlPath) throws IOException {
        URL url = new URL(urlPath);
        return url.openConnection().getInputStream();
    }

    public static BufferedImage newBufferImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 5);
        return image;
    }
}

