/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.HyperLinkTextRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.util.TableTools;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextRenderPolicy
extends AbstractRenderPolicy<Object> {
    @Override
    protected boolean validate(Object data) {
        return null != data;
    }

    @Override
    public void doRender(RenderContext<Object> context) throws Exception {
        Helper.renderTextRun(context.getRun(), context.getData());
    }

    public static class Helper {
        public static final String REGEX_LINE_CHARACTOR = "\\n";

        public static void renderTextRun(XWPFRun run, Object data) {
            TextRenderData wrapperData;
            XWPFRun textRun = run;
            if (data instanceof HyperLinkTextRenderData) {
                textRun = Helper.createHyperLinkRun(run, data);
            }
            String text = null == (wrapperData = Helper.wrapper(data)).getText() ? "" : wrapperData.getText();
            StyleUtils.styleRun(textRun, wrapperData.getStyle());
            String[] split = text.split(REGEX_LINE_CHARACTOR, -1);
            if (split.length > 0) {
                textRun.setText(split[0], 0);
                boolean lineAtTable = split.length > 1 && !(data instanceof HyperLinkTextRenderData) && TableTools.isInsideTable(run);
                for (int i = 1; i < split.length; ++i) {
                    if (lineAtTable) {
                        textRun.addBreak(BreakType.TEXT_WRAPPING);
                    } else {
                        textRun.addCarriageReturn();
                    }
                    textRun.setText(split[i]);
                }
            }
        }

        private static TextRenderData wrapper(Object obj) {
            return obj instanceof TextRenderData ? (TextRenderData)obj : new TextRenderData(obj.toString());
        }

        private static XWPFRun createHyperLinkRun(XWPFRun run, Object data) {
            XWPFParagraphWrapper paragraph = new XWPFParagraphWrapper((XWPFParagraph)run.getParent());
            XWPFRun hyperLinkRun = paragraph.insertNewHyperLinkRun(run, ((HyperLinkTextRenderData)data).getUrl());
            StyleUtils.styleRun(hyperLinkRun, run);
            run.setText("", 0);
            return hyperLinkRun;
        }
    }
}

