/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.ELObjectRenderDataCompute;
import com.deepoove.poi.render.RenderDataCompute;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.util.ObjectUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Render {
    private final Logger LOGGER = LoggerFactory.getLogger(Render.class);
    private RenderDataCompute renderDataCompute;

    public Render(Object root) {
        ObjectUtils.requireNonNull(root, "Data root is null, should be setted first.");
        this.renderDataCompute = new ELObjectRenderDataCompute(root, false);
    }

    public Render(RenderDataCompute dataCompute) {
        this.renderDataCompute = dataCompute;
    }

    public void render(XWPFTemplate template) {
        ObjectUtils.requireNonNull(template, "Template is null, should be setted first.");
        this.LOGGER.info("Render the template file start...");
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        if (null == elementTemplates || elementTemplates.isEmpty()) {
            return;
        }
        RenderPolicy policy = null;
        try {
            int docxCount = 0;
            for (ElementTemplate runTemplate : elementTemplates) {
                policy = this.findPolicy(template.getConfig(), runTemplate);
                if (policy instanceof DocxRenderPolicy) {
                    ++docxCount;
                    continue;
                }
                this.doRender(runTemplate, policy, template);
            }
            if (docxCount >= 1) {
                template.reload(template.getXWPFDocument().generate());
            }
            NiceXWPFDocument current = null;
            block3: for (int i = 0; i < docxCount; ++i) {
                current = template.getXWPFDocument();
                elementTemplates = template.getElementTemplates();
                if (null != elementTemplates && !elementTemplates.isEmpty()) {
                    for (ElementTemplate runTemplate : elementTemplates) {
                        policy = this.findPolicy(template.getConfig(), runTemplate);
                        if (!(policy instanceof DocxRenderPolicy)) continue;
                        this.doRender(runTemplate, policy, template);
                        if (current != template.getXWPFDocument()) continue block3;
                        ++i;
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.LOGGER.info("Render the template file failed.");
            throw new RenderException("Render docx failed.", e);
        }
        this.LOGGER.info("Render the template file successed.");
    }

    private RenderPolicy findPolicy(Configure config, ElementTemplate runTemplate) {
        RenderPolicy policy = config.getPolicy(runTemplate.getTagName(), runTemplate.getSign());
        if (null == policy) {
            throw new RenderException("Cannot find render policy: [" + runTemplate.getTagName() + "]");
        }
        return policy;
    }

    private void doRender(ElementTemplate ele, RenderPolicy policy, XWPFTemplate template) {
        this.LOGGER.debug("Start render TemplateName:{}, Sign:{}, policy:{}", new Object[]{ele.getTagName(), ele.getSign(), policy.getClass().getSimpleName()});
        policy.render(ele, this.renderDataCompute.compute(ele.getTagName()), template);
    }
}

