/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.TableStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RowRenderData
implements RenderData {
    private List<CellRenderData> cellDatas;
    private TableStyle rowStyle;

    public RowRenderData() {
    }

    public RowRenderData(List<CellRenderData> cellDatas) {
        this.cellDatas = cellDatas;
    }

    public static RowRenderData build(String ... cellStr) {
        ArrayList<TextRenderData> cellDatas = new ArrayList<TextRenderData>();
        if (null != cellStr) {
            for (String col : cellStr) {
                cellDatas.add(new TextRenderData(col));
            }
        }
        return new RowRenderData(cellDatas, null);
    }

    public static RowRenderData build(TextRenderData ... cellData) {
        return new RowRenderData(null == cellData ? null : Arrays.asList(cellData), null);
    }

    public RowRenderData(List<TextRenderData> rowData, String backgroundColor) {
        this.cellDatas = new ArrayList<CellRenderData>();
        if (null != rowData) {
            for (TextRenderData data : rowData) {
                this.cellDatas.add(new CellRenderData(data));
            }
        }
        TableStyle style = new TableStyle();
        style.setBackgroundColor(backgroundColor);
        this.rowStyle = style;
    }

    public int size() {
        return null == this.cellDatas ? 0 : this.cellDatas.size();
    }

    public List<CellRenderData> getCellDatas() {
        return this.cellDatas;
    }

    public void setCellDatas(List<CellRenderData> cellDatas) {
        this.cellDatas = cellDatas;
    }

    public TableStyle getRowStyle() {
        return this.rowStyle;
    }

    public void setRowStyle(TableStyle style) {
        this.rowStyle = style;
    }
}

