/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.XWPFTextboxContent;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTxbxContent;

public class XWPFRunWrapper {
    public static final String XPATH_TXBX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:Choice/*/w:txbxContent";
    public static final String XPATH_TEXTBOX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:Fallback/*/w:txbxContent";
    public static final String XPATH_PICT_TEXTBOX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace v='urn:schemas-microsoft-com:vml' ./v:shape/v:textbox/w:txbxContent";
    private final XWPFRun run;
    private XWPFTextboxContent wpstxbx;
    private XWPFTextboxContent vtextbox;
    private XWPFTextboxContent shapetxbx;

    public XWPFRunWrapper(XWPFRun run) {
        this(run, true);
    }

    public XWPFRunWrapper(XWPFRun run, boolean isParse) {
        CTPicture ctPicture;
        CTTxbxContent ctTxbxContent2;
        this.run = run;
        if (!isParse) {
            return;
        }
        CTR r = run.getCTR();
        XmlObject[] xmlObjects = r.selectPath(XPATH_TXBX_TXBXCONTENT);
        if (xmlObjects != null && xmlObjects.length >= 1) {
            try {
                ctTxbxContent2 = (CTTxbxContent)CTTxbxContent.Factory.parse(xmlObjects[0].xmlText());
                this.wpstxbx = new XWPFTextboxContent(ctTxbxContent2, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException ctTxbxContent2) {
                // empty catch block
            }
        }
        if ((xmlObjects = r.selectPath(XPATH_TEXTBOX_TXBXCONTENT)) != null && xmlObjects.length >= 1) {
            try {
                ctTxbxContent2 = (CTTxbxContent)CTTxbxContent.Factory.parse(xmlObjects[0].xmlText());
                this.vtextbox = new XWPFTextboxContent(ctTxbxContent2, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException ctTxbxContent3) {
                // empty catch block
            }
        }
        CTPicture cTPicture = ctPicture = CollectionUtils.isNotEmpty((Collection)r.getPictList()) ? r.getPictArray(0) : null;
        if (null != ctPicture && (xmlObjects = ctPicture.selectPath(XPATH_PICT_TEXTBOX_TXBXCONTENT)) != null && xmlObjects.length >= 1) {
            try {
                CTTxbxContent ctTxbxContent4 = null;
                ctTxbxContent4 = xmlObjects[0] instanceof CTTxbxContent ? (CTTxbxContent)xmlObjects[0] : (CTTxbxContent)CTTxbxContent.Factory.parse(xmlObjects[0].xmlText());
                this.shapetxbx = new XWPFTextboxContent(ctTxbxContent4, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    public XWPFRun getRun() {
        return this.run;
    }

    public XWPFTextboxContent getWpstxbx() {
        return this.wpstxbx;
    }

    public XWPFTextboxContent getVtextbox() {
        return this.vtextbox;
    }

    public XWPFTextboxContent getShapetxbx() {
        return this.shapetxbx;
    }
}

