/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.table;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.TableTools;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class SectionColumnTableRenderPolicy
implements RenderPolicy {
    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        try {
            if (!TableTools.isInsideTable(run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XWPFTableCell tagCell = (XWPFTableCell)((XWPFParagraph)run.getParent()).getBody();
            XWPFTable table = tagCell.getTableRow().getTable();
            int templateRowIndex = this.getTemplateRowIndex(tagCell);
            int templateColIndex = this.getColIndex(tagCell);
            if (null == data || data instanceof Boolean && !((Boolean)data).booleanValue()) {
                run.setText("_delete_", 0);
                CTTcPr tcPr = TableTools.getTcPr(tagCell);
                CTVMerge vMerge = tcPr.getVMerge();
                System.out.println(null == vMerge ? null : vMerge.getVal());
                if (null != vMerge && vMerge.getVal().equals(STMerge.RESTART)) {
                    XWPFTableRow row = table.getRow(templateRowIndex + 1);
                    int actualInsertPosition = this.getActualInsertPosition(row, templateColIndex);
                    XWPFTableCell actualCell = row.getCell(actualInsertPosition);
                    System.out.println(actualCell.getCTTc());
                    actualCell.getParagraphArray(0).createRun().setText("_delete_", 0);
                }
            } else {
                run.setText("", 0);
            }
        }
        catch (Exception e) {
            throw new RenderException("HackLoopTable for " + eleTemplate + "error: " + e.getMessage(), e);
        }
    }

    private int getTemplateRowIndex(XWPFTableCell tagCell) {
        XWPFTableRow tagRow = tagCell.getTableRow();
        return this.getRowIndex(tagRow);
    }

    private int getRowIndex(XWPFTableRow row) {
        List rows = row.getTable().getRows();
        return rows.indexOf(row);
    }

    private int getColIndex(XWPFTableCell cell) {
        XWPFTableRow tableRow = cell.getTableRow();
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            orginalCol += intValue;
            if (current != cell) continue;
            return orginalCol - intValue;
        }
        return -1;
    }

    private int getActualInsertPosition(XWPFTableRow tableRow, int insertPosition) {
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            if ((orginalCol += intValue) - intValue != insertPosition || intValue != 1) continue;
            return i;
        }
        return -1;
    }

    private XWPFTableCell getActualCell(XWPFTableRow tableRow, int insertPosition) {
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            if ((orginalCol += intValue) - 1 < insertPosition) continue;
            return current;
        }
        return null;
    }
}

