/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.network;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileIOOpt;
import com.centit.support.security.Md5Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlOptUtils {
    protected static final Logger logger = LoggerFactory.getLogger(UrlOptUtils.class);

    private UrlOptUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static final String getUrlParamter(String szUrl) {
        String sQuery;
        try {
            URL url = new URL(szUrl);
            sQuery = url.getQuery();
        }
        catch (MalformedURLException e) {
            int n = szUrl.indexOf(63);
            int nM = szUrl.lastIndexOf(35);
            if (nM > 0 && nM > n) {
                sQuery = n > 0 ? szUrl.substring(n + 1, nM) : szUrl.substring(0, nM);
            }
            sQuery = n > 0 ? szUrl.substring(n + 1) : "";
        }
        return sQuery;
    }

    public static Map<String, String> splitUrlParamter(String szUrlParameter) {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        int bpos = 0;
        while ((n = szUrlParameter.indexOf(61, bpos)) >= 0) {
            String value;
            String name = szUrlParameter.substring(bpos, n);
            int n2 = szUrlParameter.indexOf(38, n + 1);
            if (n2 < 0) {
                value = szUrlParameter.substring(n + 1);
                try {
                    value = URLDecoder.decode(value, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                params.put(name, value);
                break;
            }
            value = szUrlParameter.substring(n + 1, n2);
            try {
                value = URLDecoder.decode(value, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            params.put(name, value);
            bpos = n2 + 1;
        }
        return params;
    }

    public static String getUrlDomain(String curl) {
        try {
            return new URL(curl).getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String fetchFilenameFromUrl(String curl) {
        int nBpos = curl.lastIndexOf(47) + 1;
        int nEpos = curl.indexOf(63);
        if (nEpos < 0) {
            return curl.substring(nBpos);
        }
        return curl.substring(nBpos, nEpos);
    }

    public static String makeParamsToUrl(Map<String, Object> queryParam) {
        StringBuilder urlBuilder = new StringBuilder();
        int n = 0;
        for (Map.Entry<String, Object> ent : queryParam.entrySet()) {
            if (n > 0) {
                urlBuilder.append('&');
            }
            ++n;
            urlBuilder.append(ent.getKey()).append('=').append(UrlOptUtils.urlEncode(StringBaseOpt.castObjectToString(ent.getValue(), "")));
        }
        return urlBuilder.toString();
    }

    public static String appendParamToUrl(String uri, String queryUrl) {
        if (StringUtils.isBlank((CharSequence)queryUrl)) {
            return uri;
        }
        return uri.endsWith("?") || uri.endsWith("&") ? uri + queryUrl : (uri.indexOf(63) == -1 ? uri + "?" + queryUrl : uri + "&" + queryUrl);
    }

    public static String appendParamsToUrl(String uri, Map<String, Object> queryParam) {
        if (queryParam == null || queryParam.isEmpty()) {
            return uri;
        }
        return UrlOptUtils.appendParamToUrl(uri, UrlOptUtils.makeParamsToUrl(queryParam));
    }

    public static String urlDecode(String urlParam) {
        if (StringUtils.isBlank((CharSequence)urlParam)) {
            return urlParam;
        }
        try {
            return URLDecoder.decode(urlParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return urlParam;
        }
    }

    public static String urlEncode(String urlParam) {
        if (StringUtils.isBlank((CharSequence)urlParam)) {
            return urlParam;
        }
        try {
            return URLEncoder.encode(urlParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return urlParam;
        }
    }

    public static String appendParamToUrl(String uri, String paramName, Object paramValue) {
        return uri.endsWith("?") || uri.endsWith("&") ? uri + paramName + "=" + UrlOptUtils.urlEncode(StringBaseOpt.castObjectToString(paramValue, "")) : uri + (uri.indexOf(63) == -1 ? (char)'?' : '&') + paramName + "=" + UrlOptUtils.urlEncode(StringBaseOpt.castObjectToString(paramValue, ""));
    }

    public static String shortenCodeUrl(String longUrl, int urlLength) {
        if (urlLength < 4) {
            urlLength = 8;
        }
        StringBuilder sbBuilder = new StringBuilder(urlLength + 2);
        String md5Hex = "";
        int nLen = 0;
        while (nLen < urlLength) {
            int md5Len = (md5Hex = Md5Encoder.encodeBase64(md5Hex + longUrl, true)).length();
            int copylen = md5Len < urlLength - nLen ? md5Len : urlLength - nLen;
            sbBuilder.append(md5Hex, 0, copylen);
            if ((nLen += copylen) != urlLength) continue;
            break;
        }
        return sbBuilder.toString();
    }

    public static String objectToUrlString(Object objValue) {
        if (objValue == null) {
            return null;
        }
        if (objValue instanceof String) {
            return (String)objValue;
        }
        if (objValue instanceof byte[]) {
            return new String((byte[])objValue);
        }
        if (objValue instanceof Date) {
            return DatetimeOpt.convertTimestampToString((Date)objValue);
        }
        if (objValue instanceof InputStream) {
            try {
                return FileIOOpt.readStringFromInputStream((InputStream)objValue);
            }
            catch (IOException e) {
                return "";
            }
        }
        Class<?> clazz = objValue.getClass();
        if (clazz.isEnum()) {
            return ((Enum)objValue).name();
        }
        if (ReflectionOpt.isScalarType(clazz)) {
            return objValue.toString();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(objValue);
            StringBuilder sb = new StringBuilder();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    String objStr = UrlOptUtils.objectToUrlString(Array.get(objValue, i));
                    if (i > 0) {
                        if (objStr.indexOf(61) >= 0) {
                            sb.append('&');
                        } else {
                            sb.append(',');
                        }
                    }
                    sb.append(objStr);
                }
                return sb.toString();
            }
            return null;
        }
        if (objValue instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int vc = 0;
            Collection valueList = (Collection)objValue;
            for (Object ov : valueList) {
                if (ov == null) continue;
                String objStr = UrlOptUtils.objectToUrlString(ov);
                if (vc > 0) {
                    if (objStr.indexOf(61) >= 0) {
                        sb.append('&');
                    } else {
                        sb.append(',');
                    }
                }
                sb.append(objStr);
                ++vc;
            }
            return sb.toString();
        }
        Object object = JSON.toJSON((Object)objValue);
        if (object instanceof JSONObject) {
            return UrlOptUtils.makeParamsToUrl((Map<String, Object>)((JSONObject)object));
        }
        return JSON.toJSONString((Object)object);
    }
}

