/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public abstract class ZipCompressor {
    static final int BUFFER = 102400;

    private ZipCompressor() {
        throw new IllegalAccessError("Utility class");
    }

    public static ZipOutputStream convertToZipOutputStream(OutputStream os) {
        return new ZipOutputStream(new CheckedOutputStream(os, new CRC32()));
    }

    public static void compress(String zipFilePathName, String fileName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);
            String basedir = "";
            ZipCompressor.compress(file, fileName, out, basedir);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compress(String zipFilePathName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);
            String basedir = "";
            ZipCompressor.compress(file, out, basedir);
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFiles(String zipFilePathName, String[] srcPathNames) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePathName);
             ZipOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);){
            String basedir = "";
            for (String srcPathName : srcPathNames) {
                File file = new File(srcPathName);
                if (!file.exists()) continue;
                ZipCompressor.compress(file, out, basedir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFiles(String zipFilePathName, Collection<String> srcPathNames) {
        ZipCompressor.compressFiles(zipFilePathName, srcPathNames.toArray(new String[srcPathNames.size()]));
    }

    public static void compressFileInDirectory(String zipFilePathName, String srcPathName) {
        File file = new File(srcPathName);
        if (!file.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePathName);
             ZipOutputStream out = ZipCompressor.convertToZipOutputStream(fileOutputStream);){
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ZipCompressor.compress(files[i], out, "");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compress(File file, String fileName, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            ZipCompressor.compressDirectory(file, out, basedir);
        } else {
            ZipCompressor.compressFile(file, fileName, out, basedir);
        }
    }

    public static void compress(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            ZipCompressor.compressDirectory(file, out, basedir);
        } else {
            ZipCompressor.compressFile(file, file.getName(), out, basedir);
        }
    }

    public static void compressDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            ZipCompressor.compress(files[i], out, basedir + dir.getName() + "/");
        }
    }

    public static void compressFile(InputStream fis, String fileName, ZipOutputStream out, String basedir) {
        String filePath = StringUtils.isBlank((CharSequence)basedir) ? fileName : (basedir.endsWith("/") || basedir.endsWith("\\") ? basedir + fileName : basedir + File.separatorChar + fileName);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            int count;
            ZipEntry entry = new ZipEntry(filePath);
            out.putNextEntry(entry);
            byte[] data = new byte[102400];
            while ((count = bis.read(data, 0, 102400)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFile(File file, String fileName, ZipOutputStream out, String basedir) {
        if (!file.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ZipCompressor.compressFile(fis, fileName, out, basedir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void compressFile(File file, ZipOutputStream out, String basedir) {
        ZipCompressor.compressFile(file, file.getName(), out, basedir);
    }

    public static void release(String zipPath, String dirPath) {
        ZipCompressor.release(new File(zipPath), dirPath);
    }

    public static void release(File zipFile, String dirPath) {
        File pathFile;
        String descDir = dirPath;
        if (!descDir.endsWith("/")) {
            descDir = dirPath + "/";
        }
        if (!(pathFile = new File(descDir)).exists()) {
            pathFile.mkdirs();
        }
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                String outPath = (descDir + zipEntryName).replaceAll("\\*", "/");
                File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(outPath);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf1 = new byte[1024];
                        while ((len = in.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

