/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson2.util.TypeUtils;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class GeneralAlgorithm {
    private GeneralAlgorithm() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> T nvl(T obj, T obj2) {
        return obj == null ? obj2 : obj;
    }

    public static <T> T nvl2(Object obj, T obj2, T obj3) {
        return obj == null ? obj3 : obj2;
    }

    public static boolean equals(Object operand, Object operand2, boolean allNullAsTrue) {
        if (allNullAsTrue) {
            if (operand == operand2) {
                return true;
            }
            if (operand == null || operand2 == null) {
                return false;
            }
        } else {
            if (operand == null || operand2 == null) {
                return false;
            }
            if (operand == operand2) {
                return true;
            }
        }
        if (operand.getClass().equals(operand2.getClass())) {
            return operand.equals(operand2);
        }
        if (operand instanceof Number && operand2 instanceof Number) {
            return NumberBaseOpt.castObjectToDouble(operand).compareTo(NumberBaseOpt.castObjectToDouble(operand2)) == 0;
        }
        return StringBaseOpt.objectToString(operand).compareTo(StringBaseOpt.objectToString(operand2)) == 0;
    }

    public static boolean equals(Object operand, Object operand2) {
        return GeneralAlgorithm.equals(operand, operand2, true);
    }

    public static int compareTwoObject(Object operand, Object operand2, boolean nullAsFirst) {
        if (operand == null && operand2 == null) {
            return 0;
        }
        if (operand == null) {
            return nullAsFirst ? -1 : 1;
        }
        if (operand2 == null) {
            return nullAsFirst ? 1 : -1;
        }
        if (operand instanceof Comparable && operand2 instanceof Comparable && operand.getClass().equals(operand2.getClass())) {
            if (operand instanceof String) {
                Collator compare = Collator.getInstance(Locale.CHINA);
                return compare.compare(operand, operand2);
            }
            return ObjectUtils.compare((Comparable)((Comparable)operand), (Comparable)((Comparable)operand2));
        }
        if (NumberBaseOpt.isNumber(operand) && NumberBaseOpt.isNumber(operand2)) {
            return ObjectUtils.compare((Comparable)NumberBaseOpt.castObjectToDouble(operand), (Comparable)NumberBaseOpt.castObjectToDouble(operand2));
        }
        Collator compare = Collator.getInstance(Locale.CHINA);
        return compare.compare(StringBaseOpt.objectToString(operand), StringBaseOpt.objectToString(operand2));
    }

    public static int compareTwoObject(Object operand, Object operand2) {
        return GeneralAlgorithm.compareTwoObject(operand, operand2, true);
    }

    public static boolean betweenTwoObject(Object operand, Object obj1, Object obj2) {
        int b;
        int a = GeneralAlgorithm.compareTwoObject(operand, obj1);
        return a * (b = GeneralAlgorithm.compareTwoObject(operand, obj2)) <= 0;
    }

    public static int compareTwoObjectByField(Object data1, Object data2, String[] fields, boolean nullAsFirst) {
        if (data1 == null && data2 == null || fields == null) {
            return 0;
        }
        if (data1 == null) {
            return nullAsFirst ? -1 : 1;
        }
        if (data2 == null) {
            return nullAsFirst ? 1 : -1;
        }
        for (String field : fields) {
            Object obj2;
            Object obj1 = data1 instanceof Map ? ((Map)data1).get(field) : ReflectionOpt.getFieldValue(data1, field);
            int cr = GeneralAlgorithm.compareTwoObject(obj1, obj2 = data2 instanceof Map ? ((Map)data2).get(field) : ReflectionOpt.getFieldValue(data2, field), nullAsFirst);
            if (cr == 0) continue;
            return cr;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compareTwoComparableObject(T l1, T l2, boolean nullAsFirst) {
        return l1 == null && l2 == null ? 0 : (l1 == null ? (nullAsFirst ? -1 : 1) : (l2 == null ? (nullAsFirst ? 1 : -1) : l1.compareTo(l2)));
    }

    public static <T extends Comparable<? super T>> int compareTwoComparableObject(T l1, T l2) {
        return GeneralAlgorithm.compareTwoComparableObject(l1, l2, true);
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor, boolean nullAsFirst) {
        Objects.requireNonNull(keyExtractor);
        return (Comparator & Serializable)(c1, c2) -> GeneralAlgorithm.compareTwoComparableObject((Comparable)keyExtractor.apply(c1), (Comparable)keyExtractor.apply(c2), nullAsFirst);
    }

    private static int getJavaTypeOrder(Object a) {
        switch (ReflectionOpt.getJavaTypeName(a.getClass())) {
            case "int": 
            case "Integer": {
                return 1;
            }
            case "long": 
            case "Long": {
                return 2;
            }
            case "float": 
            case "Float": {
                return 3;
            }
            case "double": 
            case "Double": {
                return 4;
            }
            case "BigInteger": {
                return 5;
            }
            case "BigDecimal": {
                return 6;
            }
            case "String": {
                return 10;
            }
        }
        return 100;
    }

    private static Object checkStringObject(Object obj) {
        if (obj instanceof String && StringRegularOpt.isNumber((String)obj)) {
            return NumberBaseOpt.castObjectToNumber(obj);
        }
        return obj;
    }

    public static Object addTwoObject(Object a, Object b, boolean nullSensitive) {
        if (a == null) {
            if (nullSensitive && (b == null || b instanceof Number)) {
                return null;
            }
            return b;
        }
        if (b == null) {
            if (nullSensitive && a instanceof Number) {
                return null;
            }
            return a;
        }
        a = GeneralAlgorithm.checkStringObject(a);
        b = GeneralAlgorithm.checkStringObject(b);
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) + NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) + NumberBaseOpt.castObjectToLong(b);
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).add(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).add(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) + NumberBaseOpt.castObjectToDouble(b);
        }
        if (a instanceof Date && NumberBaseOpt.isNumber(b)) {
            float num = NumberBaseOpt.castObjectToFloat(b, Float.valueOf(0.0f)).floatValue();
            return DatetimeOpt.addDays((Date)a, num);
        }
        if (a instanceof Collection) {
            ArrayList<Object> objs = new ArrayList<Object>();
            if (b instanceof Collection) {
                objs.addAll((Collection)a);
                objs.addAll((Collection)b);
            } else {
                for (Object obj : (Collection)a) {
                    objs.add(GeneralAlgorithm.addTwoObject(obj, b, nullSensitive));
                }
            }
            return objs;
        }
        return StringBaseOpt.concat(StringBaseOpt.castObjectToString(a), StringBaseOpt.castObjectToString(b));
    }

    public static Object addTwoObject(Object a, Object b) {
        return GeneralAlgorithm.addTwoObject(a, b, true);
    }

    public static Object subtractTwoObject(Object a, Object b) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            if (a instanceof Number) {
                return null;
            }
            return a;
        }
        a = GeneralAlgorithm.checkStringObject(a);
        b = GeneralAlgorithm.checkStringObject(b);
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) - NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) - NumberBaseOpt.castObjectToLong(b);
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).subtract(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).subtract(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) - NumberBaseOpt.castObjectToDouble(b);
        }
        if (a instanceof Date) {
            if (b instanceof Date) {
                return DatetimeOpt.calcDateSpan((Date)a, (Date)b);
            }
            if (NumberBaseOpt.isNumber(b)) {
                float num = NumberBaseOpt.castObjectToFloat(b, Float.valueOf(0.0f)).floatValue();
                return DatetimeOpt.addDays((Date)a, 0.0f - num);
            }
        } else if (a instanceof Collection) {
            ArrayList<Object> objs = new ArrayList<Object>();
            if (b instanceof Collection) {
                objs.addAll((Collection)a);
                objs.removeAll((Collection)b);
            } else {
                for (Object obj : (Collection)a) {
                    objs.add(GeneralAlgorithm.subtractTwoObject(obj, b));
                }
            }
            return objs;
        }
        return a;
    }

    public static Object multiplyTwoObject(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        a = GeneralAlgorithm.checkStringObject(a);
        b = GeneralAlgorithm.checkStringObject(b);
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) * NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) * NumberBaseOpt.castObjectToLong(b);
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).multiply(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).multiply(NumberBaseOpt.castObjectToBigDecimal(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) * NumberBaseOpt.castObjectToDouble(b);
        }
        if (a instanceof Collection) {
            ArrayList<Object> objs = new ArrayList<Object>();
            if (b instanceof Collection) {
                ArrayList aobjs = new ArrayList();
                aobjs.addAll((Collection)a);
                for (Object obj : (Collection)b) {
                    if (!aobjs.contains(obj)) continue;
                    objs.add(obj);
                }
            } else {
                for (Object obj : (Collection)a) {
                    objs.add(GeneralAlgorithm.multiplyTwoObject(obj, b));
                }
            }
            return objs;
        }
        if (b instanceof Number) {
            int bi = NumberBaseOpt.castObjectToInteger(b);
            return StringUtils.repeat((String)StringBaseOpt.castObjectToString(a), (int)bi);
        }
        return StringBaseOpt.concat(StringBaseOpt.castObjectToString(a), StringBaseOpt.castObjectToString(b));
    }

    public static Object divideTwoObject(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        a = GeneralAlgorithm.checkStringObject(a);
        b = GeneralAlgorithm.checkStringObject(b);
        if (a instanceof Number && b instanceof Number) {
            BigDecimal dbop2 = NumberBaseOpt.castObjectToBigDecimal(b);
            if (dbop2 == null || dbop2.compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) / NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) / NumberBaseOpt.castObjectToLong(b);
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).divide(NumberBaseOpt.castObjectToBigInteger(b));
                }
                case 6: {
                    return NumberBaseOpt.castObjectToBigDecimal(a).divide(NumberBaseOpt.castObjectToBigDecimal(b), 20, RoundingMode.HALF_EVEN);
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) / NumberBaseOpt.castObjectToDouble(b);
        }
        if (a instanceof Collection) {
            ArrayList<Object> objs = new ArrayList<Object>();
            for (Object obj : (Collection)a) {
                objs.add(GeneralAlgorithm.divideTwoObject(obj, b));
            }
            return objs;
        }
        return a;
    }

    public static Object modTwoObject(Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        a = GeneralAlgorithm.checkStringObject(a);
        b = GeneralAlgorithm.checkStringObject(b);
        if (a instanceof Number && b instanceof Number) {
            int retType = Math.max(GeneralAlgorithm.getJavaTypeOrder(a), GeneralAlgorithm.getJavaTypeOrder(b));
            switch (retType) {
                case 1: {
                    return NumberBaseOpt.castObjectToInteger(a) % NumberBaseOpt.castObjectToInteger(b);
                }
                case 2: {
                    return NumberBaseOpt.castObjectToLong(a) % NumberBaseOpt.castObjectToLong(b);
                }
                case 3: {
                    return Float.valueOf(NumberBaseOpt.castObjectToFloat(a).floatValue() % NumberBaseOpt.castObjectToFloat(b).floatValue());
                }
                case 5: {
                    return NumberBaseOpt.castObjectToBigInteger(a).mod(NumberBaseOpt.castObjectToBigInteger(b));
                }
            }
            return NumberBaseOpt.castObjectToDouble(a) % NumberBaseOpt.castObjectToDouble(b);
        }
        return a;
    }

    public static Object maxObject(Collection<Object> ar) {
        int retType;
        if (ar == null || ar.isEmpty()) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object maxObject = ar.iterator().next();
        if (ar.size() == 1) {
            return maxObject;
        }
        int n = retType = maxObject == null ? -1 : GeneralAlgorithm.getJavaTypeOrder(maxObject);
        block8: while (ari.hasNext()) {
            Object anOther = ari.next();
            if (anOther == null) continue;
            if (maxObject == null) {
                maxObject = anOther;
                retType = GeneralAlgorithm.getJavaTypeOrder(maxObject);
                continue;
            }
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToInteger(maxObject), NumberBaseOpt.castObjectToInteger(anOther));
                    continue block8;
                }
                case 2: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToLong(maxObject), NumberBaseOpt.castObjectToLong(anOther));
                    continue block8;
                }
                case 3: {
                    maxObject = Float.valueOf(Math.max(NumberBaseOpt.castObjectToFloat(maxObject).floatValue(), NumberBaseOpt.castObjectToFloat(anOther).floatValue()));
                    continue block8;
                }
                case 5: {
                    maxObject = NumberBaseOpt.castObjectToBigInteger(maxObject).max(NumberBaseOpt.castObjectToBigInteger(anOther));
                    continue block8;
                }
                case 6: {
                    maxObject = NumberBaseOpt.castObjectToBigDecimal(maxObject).max(NumberBaseOpt.castObjectToBigDecimal(anOther));
                    continue block8;
                }
                case 4: {
                    maxObject = Math.max(NumberBaseOpt.castObjectToDouble(maxObject), NumberBaseOpt.castObjectToDouble(anOther));
                    continue block8;
                }
            }
            String str1 = StringBaseOpt.castObjectToString(maxObject);
            String str2 = StringBaseOpt.castObjectToString(anOther);
            maxObject = str1.compareTo(str2) > 0 ? str1 : str2;
        }
        return maxObject;
    }

    public static Object minObject(Collection<Object> ar) {
        int retType;
        if (ar == null || ar.size() < 1) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object minObject = ar.iterator().next();
        if (ar.size() == 1) {
            return minObject;
        }
        int n = retType = minObject == null ? -1 : GeneralAlgorithm.getJavaTypeOrder(minObject);
        block8: while (ari.hasNext()) {
            Object anOther = ari.next();
            if (anOther == null) continue;
            if (minObject == null) {
                minObject = anOther;
                retType = GeneralAlgorithm.getJavaTypeOrder(minObject);
                continue;
            }
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    minObject = Math.min(NumberBaseOpt.castObjectToInteger(minObject), NumberBaseOpt.castObjectToInteger(anOther));
                    continue block8;
                }
                case 2: {
                    minObject = Math.min(NumberBaseOpt.castObjectToLong(minObject), NumberBaseOpt.castObjectToLong(anOther));
                    continue block8;
                }
                case 3: {
                    minObject = Float.valueOf(Math.min(NumberBaseOpt.castObjectToFloat(minObject).floatValue(), NumberBaseOpt.castObjectToFloat(anOther).floatValue()));
                    continue block8;
                }
                case 5: {
                    minObject = NumberBaseOpt.castObjectToBigInteger(minObject).min(NumberBaseOpt.castObjectToBigInteger(anOther));
                    continue block8;
                }
                case 6: {
                    minObject = NumberBaseOpt.castObjectToBigDecimal(minObject).min(NumberBaseOpt.castObjectToBigDecimal(anOther));
                    continue block8;
                }
                case 4: {
                    minObject = Math.min(NumberBaseOpt.castObjectToDouble(minObject), NumberBaseOpt.castObjectToDouble(anOther));
                    continue block8;
                }
            }
            String str1 = StringBaseOpt.castObjectToString(minObject);
            String str2 = StringBaseOpt.castObjectToString(anOther);
            minObject = str1.compareTo(str2) < 0 ? str1 : str2;
        }
        return minObject;
    }

    public static Object sumObjects(Collection<Object> ar) {
        if (ar.size() < 1) {
            return null;
        }
        Iterator<Object> ari = ar.iterator();
        Object sumObj = null;
        while (sumObj == null && ari.hasNext()) {
            sumObj = ari.next();
        }
        if (sumObj == null) {
            return null;
        }
        int retType = GeneralAlgorithm.getJavaTypeOrder(sumObj);
        block9: while (ari.hasNext()) {
            Object anOther = ari.next();
            if (anOther == null) continue;
            retType = Math.max(retType, GeneralAlgorithm.getJavaTypeOrder(anOther));
            switch (retType) {
                case 1: {
                    sumObj = NumberBaseOpt.castObjectToInteger(sumObj, 0) + NumberBaseOpt.castObjectToInteger(anOther, 0);
                    continue block9;
                }
                case 2: {
                    sumObj = NumberBaseOpt.castObjectToLong(sumObj, 0L) + NumberBaseOpt.castObjectToLong(anOther, 0L);
                    continue block9;
                }
                case 3: {
                    sumObj = Float.valueOf(NumberBaseOpt.castObjectToFloat(sumObj, Float.valueOf(0.0f)).floatValue() + NumberBaseOpt.castObjectToFloat(anOther, Float.valueOf(0.0f)).floatValue());
                    continue block9;
                }
                case 5: {
                    sumObj = NumberBaseOpt.castObjectToBigInteger(sumObj, BigInteger.ZERO).add(NumberBaseOpt.castObjectToBigInteger(anOther, BigInteger.ZERO));
                    continue block9;
                }
                case 6: {
                    sumObj = NumberBaseOpt.castObjectToBigDecimal(sumObj, BigDecimal.ZERO).add(NumberBaseOpt.castObjectToBigDecimal(anOther, BigDecimal.ZERO));
                    continue block9;
                }
                case 4: {
                    sumObj = NumberBaseOpt.castObjectToDouble(sumObj, 0.0) + NumberBaseOpt.castObjectToDouble(anOther, 0.0);
                    continue block9;
                }
            }
            sumObj = StringBaseOpt.concat(StringBaseOpt.castObjectToString(sumObj), StringBaseOpt.castObjectToString(anOther));
        }
        return sumObj;
    }

    public static Object castObjectToType(Object obj, Class<?> type) {
        return TypeUtils.cast((Object)obj, type);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isBlank((CharSequence)((String)obj));
        }
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            return objMap.isEmpty();
        }
        if (obj instanceof Collection) {
            Collection objlist = (Collection)obj;
            if (objlist.isEmpty()) {
                return true;
            }
            for (Object obj1 : objlist) {
                if (GeneralAlgorithm.isEmpty(obj1)) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] objs;
            for (Object obj1 : objs = (Object[])obj) {
                if (GeneralAlgorithm.isEmpty(obj1)) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Supplier) {
            Object retObj = ((Supplier)obj).get();
            return GeneralAlgorithm.isEmpty(retObj);
        }
        return StringUtils.isBlank((CharSequence)StringBaseOpt.castObjectToString(obj));
    }
}

