/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.json.DefaultJSONTransformDataSupport;
import com.centit.support.json.JSONTransformDataSupport;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTransformer {
    protected static final Logger logger = LoggerFactory.getLogger(JSONTransformer.class);

    public static void putObjectToJson(JSONObject jobj, String key, Object value) {
        if (value == null) {
            jobj.remove((Object)key);
            return;
        }
        jobj.put((Object)key, value);
    }

    public static void addObjectToJson(JSONArray jArray, Object value) {
        if (value != null) {
            jArray.add(value);
        }
    }

    public static Object transformer(Object templateObj, JSONTransformDataSupport dataSupport) {
        if (templateObj == null) {
            return null;
        }
        if (templateObj instanceof String) {
            String value = (String)templateObj;
            if (value.isEmpty()) {
                return null;
            }
            if (value.charAt(0) == '@') {
                return dataSupport.mapTemplateString(value.substring(1));
            }
            if (value.charAt(0) == '#') {
                String formula = dataSupport.mapTemplateString(value.substring(1));
                return dataSupport.attainExpressionValue(formula);
            }
            return dataSupport.attainExpressionValue(value);
        }
        if (templateObj instanceof Map) {
            Map<String, Object> tempMap = CollectionsOpt.objectToMap(templateObj);
            JSONObject jObj = new JSONObject();
            for (Map.Entry<String, Object> ent : tempMap.entrySet()) {
                String sKey = ent.getKey();
                if (sKey.isEmpty()) {
                    return null;
                }
                if (sKey.charAt(0) == '@') {
                    Object value = JSONTransformer.transformer(ent.getValue(), dataSupport);
                    if (value instanceof Map) {
                        jObj.putAll(CollectionsOpt.objectToMap(value));
                        continue;
                    }
                    JSONTransformer.putObjectToJson(jObj, sKey.substring(1), value);
                    continue;
                }
                if (sKey.charAt(0) == '#') {
                    Object obj = dataSupport.attainExpressionValue(sKey.substring(1));
                    if (obj == null) {
                        return null;
                    }
                    if (!(obj instanceof Collection)) {
                        logger.warn(sKey.substring(1) + "\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u662f\u6570\u7ec4");
                    }
                    JSONArray array = new JSONArray();
                    List<Object> loopData = CollectionsOpt.objectToList(obj);
                    int loopSize = loopData.size();
                    int index = 0;
                    for (Object ld : loopData) {
                        dataSupport.pushStackValue(ld, index, loopSize);
                        if (StringUtils.isBlank((CharSequence)String.valueOf(ent.getValue())) || ".".equals(String.valueOf(ent.getValue()))) {
                            JSONTransformer.addObjectToJson(array, ld);
                        } else {
                            JSONTransformer.addObjectToJson(array, JSONTransformer.transformer(ent.getValue(), dataSupport));
                        }
                        dataSupport.popStackValue();
                        ++index;
                    }
                    return array.isEmpty() ? null : array;
                }
                JSONTransformer.putObjectToJson(jObj, sKey, JSONTransformer.transformer(ent.getValue(), dataSupport));
            }
            return jObj.isEmpty() ? null : jObj;
        }
        if (templateObj instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection valueList = (Collection)templateObj;
            for (Object ov : valueList) {
                if (ov == null) continue;
                Object transValue = JSONTransformer.transformer(ov, dataSupport);
                if (!(ov instanceof Collection) && transValue instanceof Collection) {
                    array.addAll((Collection)transValue);
                    continue;
                }
                JSONTransformer.addObjectToJson(array, transValue);
            }
            return array.isEmpty() ? null : array;
        }
        Class<?> clazz = templateObj.getClass();
        if (clazz.isArray()) {
            JSONArray array = new JSONArray();
            int len = Array.getLength(templateObj);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    JSONTransformer.addObjectToJson(array, JSONTransformer.transformer(Array.get(templateObj, i), dataSupport));
                }
            }
            return array.isEmpty() ? null : array;
        }
        return templateObj;
    }

    public static Object transformer(Object templateObj, Object dataSupport) {
        return JSONTransformer.transformer(templateObj, new DefaultJSONTransformDataSupport(dataSupport));
    }
}

