/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.xml;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private final List<String> errorMessage = new ArrayList<String>();
    private final List<String> warningMessage = new ArrayList<String>();
    private final List<String> fatalErrorMessage = new ArrayList<String>();

    public JSONObject toJSONObject() {
        JSONObject errorJson = new JSONObject();
        int errorCount = this.errorMessage.size();
        int fatalErrorCount = this.fatalErrorMessage.size();
        int warningCount = this.warningMessage.size();
        if (errorCount == 0) {
            errorJson.put((Object)"code", (Object)"0");
            if (warningCount > 0) {
                errorJson.put((Object)"message", (Object)("XML\u6587\u4ef6\u683c\u5f0f\u9a8c\u8bc1\u901a\u8fc7\uff0c\u4f46\u662f\u6709" + warningCount + "\u4e2a\u8b66\u544a"));
            } else {
                errorJson.put((Object)"message", (Object)"OK");
            }
        } else {
            errorJson.put((Object)"code", (Object)701);
            errorJson.put((Object)"message", (Object)("XML\u6587\u4ef6\u683c\u5f0f\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0c\u6709" + errorCount + "\u4e2a\u9519\u8bef\uff0c\u548c" + fatalErrorCount + "\u4e2a\u81f4\u547d\u9519\u8bef"));
        }
        errorJson.put((Object)"data", CollectionsOpt.createHashMap("errorCount", errorCount, "warningCount", warningCount, "fatalErrorCount", fatalErrorCount, "errorMessage", this.errorMessage, "warningMessage", this.warningMessage, "fatalErrorMessage", this.fatalErrorMessage));
        return errorJson;
    }

    public static JSONObject createFatalError(String fatalMessage) {
        JSONObject errorJson = new JSONObject();
        errorJson.put((Object)"code", (Object)"0");
        errorJson.put((Object)"message", (Object)"XML\u6587\u4ef6\u683c\u5f0f\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0c\u6709 1 \u4e2a\u81f4\u547d\u9519\u8bef");
        errorJson.put((Object)"data", CollectionsOpt.createHashMap("errorCount", 0, "warningCount", 0, "fatalErrorCount", 1, "fatalErrorMessage", Collections.singletonList(fatalMessage)));
        return errorJson;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.warningMessage.add(exception.getMessage() + " at " + exception.getLineNumber() + ":" + exception.getColumnNumber());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.errorMessage.add(exception.getMessage() + " at " + exception.getLineNumber() + ":" + exception.getColumnNumber());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.fatalErrorMessage.add(exception.getMessage() + " at " + exception.getLineNumber() + ":" + exception.getColumnNumber());
    }
}

