/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.algorithm;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ParamName;
import com.centit.support.file.FileType;
import com.centit.support.json.JSONOpt;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionOpt {
    protected static final Logger logger = LoggerFactory.getLogger(ReflectionOpt.class);

    private ReflectionOpt() {
        throw new IllegalAccessError("Utility class");
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        return ReflectionOpt.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) throws NoSuchFieldException {
        assert (clazz != null);
        assert (propertyName != null && !propertyName.isEmpty());
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field f = superClass.getDeclaredField(propertyName);
                if (f == null) continue;
                return f;
            }
            catch (NoSuchFieldException e) {
                logger.debug(e.getMessage());
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetFieldValue(Object object, Field field) {
        assert (object != null);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.info("error wont' happen." + e.getMessage());
        }
        if (!accessible) {
            field.setAccessible(accessible);
        }
        return result;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Method md = null;
        try {
            md = obj.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
        }
        catch (NoSuchMethodException noGet) {
            try {
                md = obj.getClass().getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
            }
            catch (Exception e) {
                logger.error(noGet.getMessage() + ", " + e.getMessage());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (md == null) {
            try {
                return ReflectionOpt.forceGetProperty(obj, fieldName);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        } else {
            try {
                return md.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    public static boolean setFieldValue(Object object, String fieldName, Object newValue, Class<?> paramType) {
        Class<?> relParamType = paramType != null ? paramType : (newValue != null ? newValue.getClass() : null);
        boolean hasSetValue = false;
        if (relParamType != null) {
            try {
                Method md = object.getClass().getMethod("set" + StringUtils.capitalize((String)fieldName), relParamType);
                md.invoke(object, newValue);
                hasSetValue = true;
            }
            catch (NoSuchMethodException noSet) {
                logger.error(noSet.getMessage(), (Throwable)noSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (!hasSetValue) {
            try {
                ReflectionOpt.forceSetProperty(object, fieldName, newValue);
                hasSetValue = true;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return hasSetValue;
    }

    public static boolean setFieldValue(Object object, String fieldName, Object newValue) {
        return ReflectionOpt.setFieldValue(object, fieldName, newValue, null);
    }

    public static boolean setAttributeValue(Object object, String attributeName, Object newValue) {
        if (object == null) {
            return false;
        }
        if (object instanceof JSONObject) {
            JSONOpt.setAttribute((JSONObject)object, attributeName, newValue);
            return true;
        }
        int dotPos = attributeName.indexOf(".");
        if (dotPos > 0) {
            Object fieldValue;
            String fieldName = attributeName.substring(0, dotPos);
            if (object instanceof Map) {
                Map map = (Map)object;
                fieldValue = map.get(fieldName);
            } else {
                fieldValue = ReflectionOpt.getFieldValue(object, fieldName);
            }
            if (fieldValue == null) {
                return false;
            }
            return ReflectionOpt.setAttributeValue(fieldValue, attributeName.substring(dotPos + 1), newValue);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            map.put(attributeName, newValue);
            return true;
        }
        return ReflectionOpt.setFieldValue(object, attributeName, newValue);
    }

    public static Object getFieldValue(Object obj, Field field) {
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        return ReflectionOpt.forceGetFieldValue(object, field);
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        assert (object != null);
        assert (propertyName != null && !propertyName.isEmpty());
        Field field = ReflectionOpt.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            logger.error("Error won't happen." + e.getMessage(), (Throwable)e);
        }
        if (!accessible) {
            field.setAccessible(accessible);
        }
    }

    public static Field[] getFields(Object object) {
        return object.getClass().getDeclaredFields();
    }

    public static List<Field> getFieldsByType(Object object, Class<?> type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            list.add(field);
        }
        return list;
    }

    public static Class<?> getPropertyType(Class<?> type, String name) throws NoSuchFieldException {
        return ReflectionOpt.getDeclaredField(type, name).getType();
    }

    public static String methodNameToField(String methodName) {
        if (methodName == null) {
            return null;
        }
        int sl = methodName.length();
        if (sl > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (sl > 2 && methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName;
    }

    public static Method getGetterMethod(Class<?> classType, Class<?> propertyType, String fieldName) {
        try {
            String getFuncName = Boolean.TYPE.equals(propertyType) ? "is" + StringUtils.capitalize((String)fieldName) : "get" + StringUtils.capitalize((String)fieldName);
            Method md = classType.getMethod(getFuncName, new Class[0]);
            if (propertyType.isAssignableFrom(md.getReturnType())) {
                return md;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Method getGetterMethod(Class<?> classType, String fieldName) {
        try {
            Method md = classType.getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (Void.TYPE.equals(md.getReturnType())) {
                return null;
            }
            return md;
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> classType, Class<?> propertyType, String fieldName) {
        try {
            return classType.getMethod("set" + StringUtils.capitalize((String)fieldName), propertyType);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static LeftRightPair<Method, Object[]> getMatchBestMethod(Class<?> classType, String methodName, Map<String, Object> params) {
        Method[] mths = classType.getMethods();
        ArrayList getMths = new ArrayList();
        int matchParam = -1;
        LeftRightPair<Method, Object[]> mp = new LeftRightPair<Method, Object[]>();
        for (Method mth : mths) {
            if (!mth.getName().equals(methodName)) continue;
            Parameter[] parameters = mth.getParameters();
            int nps = parameters.length;
            boolean bmatch = true;
            Object[] prams = null;
            if (nps > 0) {
                prams = new Object[nps];
                for (int i = 0; i < nps; ++i) {
                    String paramName = parameters[i].getName();
                    if (parameters[i].isAnnotationPresent(ParamName.class)) {
                        ParamName param = parameters[i].getAnnotation(ParamName.class);
                        paramName = param.value();
                    }
                    prams[i] = params.get(paramName);
                    if (prams[i] == null) {
                        bmatch = false;
                        continue;
                    }
                    prams[i] = GeneralAlgorithm.castObjectToType(prams[i], parameters[i].getType());
                    if (prams[i] != null) continue;
                    bmatch = false;
                }
            }
            if (!bmatch || nps <= matchParam) continue;
            matchParam = nps;
            mp.setLeft(mth);
            mp.setRight(prams);
        }
        return mp;
    }

    private static void innerAddListItem(List<Object> objList, Object obj) {
        if (obj instanceof Collection) {
            Collection templist = (Collection)obj;
            objList.addAll(templist);
        } else if (obj instanceof Object[]) {
            Object[] objs;
            for (Object tobj : objs = (Object[])obj) {
                objList.add(tobj);
            }
        } else {
            objList.add(obj);
        }
    }

    private static LeftRightPair<String, String> splitLabel(String labelStr) {
        int bPos;
        int len = labelStr.length();
        for (bPos = 0; bPos < len && (labelStr.charAt(bPos) == ' ' || labelStr.charAt(bPos) == '.'); ++bPos) {
        }
        String currentLabel = ".";
        String restLabel = ".";
        if (bPos < len) {
            if (labelStr.charAt(bPos) == '[') {
                int ePos;
                for (ePos = ++bPos; ePos < len && labelStr.charAt(ePos) != ']'; ++ePos) {
                }
                if (ePos > bPos) {
                    currentLabel = labelStr.substring(bPos, ePos).trim();
                }
                if (ePos + 1 < len) {
                    restLabel = labelStr.substring(ePos + 1);
                }
            } else {
                int ePos;
                for (ePos = bPos; ePos < len && labelStr.charAt(ePos) != '.' && labelStr.charAt(ePos) != '['; ++ePos) {
                }
                if (ePos > bPos) {
                    currentLabel = labelStr.substring(bPos, ePos).trim();
                }
                if (ePos < len) {
                    restLabel = labelStr.substring(ePos);
                }
            }
        }
        return new LeftRightPair<String, String>(currentLabel, restLabel);
    }

    public static Object attainExpressionValue(Object sourceObj, String expression) {
        if (sourceObj == null || StringUtils.isBlank((CharSequence)expression) || ".".equals(expression)) {
            return sourceObj;
        }
        if (ReflectionOpt.isScalarType(sourceObj.getClass())) {
            return null;
        }
        LeftRightPair<String, String> labels = ReflectionOpt.splitLabel(expression);
        String fieldValue = labels.getLeft();
        String restExpression = labels.getRight();
        Object retObj = null;
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            retObj = sourceObj;
        } else if (sourceObj instanceof Map) {
            Map objMap = (Map)sourceObj;
            retObj = objMap.get(fieldValue);
            if (retObj == null && "0".equals(fieldValue)) {
                retObj = sourceObj;
            }
        } else if (sourceObj instanceof Collection) {
            Collection objlist = (Collection)sourceObj;
            int objSize = objlist.size();
            if (StringRegularOpt.isDigit(fieldValue)) {
                int index = NumberBaseOpt.castObjectToInteger(fieldValue);
                if (index >= objSize) {
                    return null;
                }
                int i = 0;
                for (Object obj : objlist) {
                    if (i == index) {
                        retObj = obj;
                        break;
                    }
                    ++i;
                }
            } else {
                ArrayList<Object> retList = new ArrayList<Object>(objSize + 1);
                for (Object obj : objlist) {
                    Object tempObj = ReflectionOpt.attainExpressionValue(obj, fieldValue);
                    ReflectionOpt.innerAddListItem(retList, tempObj);
                }
                retObj = retList;
            }
        } else if (sourceObj instanceof Object[]) {
            Object[] objs = (Object[])sourceObj;
            if (StringRegularOpt.isDigit(fieldValue)) {
                int index = NumberBaseOpt.castObjectToInteger(fieldValue);
                if (index >= objs.length) {
                    return null;
                }
                retObj = objs[index];
            } else {
                ArrayList<Object> retList = new ArrayList<Object>(objs.length + 1);
                for (Object obj : objs) {
                    Object tempObj = ReflectionOpt.attainExpressionValue(obj, fieldValue);
                    ReflectionOpt.innerAddListItem(retList, tempObj);
                }
                retObj = retList;
            }
        } else {
            retObj = "0".equals(fieldValue) ? sourceObj : ReflectionOpt.getFieldValue(sourceObj, fieldValue);
        }
        if (retObj instanceof Supplier) {
            retObj = ((Supplier)retObj).get();
        }
        return ReflectionOpt.attainExpressionValue(retObj, restExpression);
    }

    public static Boolean getBooleanFieldValue(Object obj, String fieldName) {
        try {
            Method md = obj.getClass().getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
            if (md == null) {
                return null;
            }
            Object objValue = md.invoke(obj, new Object[0]);
            if (objValue == null) {
                return null;
            }
            if (objValue instanceof Boolean) {
                return (Boolean)objValue;
            }
            return Boolean.valueOf(objValue.toString());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Method getBooleanGetterMethod(Class<?> classType, String fieldName) {
        try {
            return classType.getMethod("is" + StringUtils.capitalize((String)fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String mapGetter2Field(Method method) {
        String methodName;
        return StringUtils.uncapitalize((String)methodName.substring((methodName = method.getName()).startsWith("is") ? 2 : 3));
    }

    public static List<Method> getAllGetterMethod(Class<?> type) {
        try {
            Method[] mths = type.getMethods();
            ArrayList<Method> getMths = new ArrayList<Method>();
            for (Method mth : mths) {
                if (!mth.getName().startsWith("get") && !mth.getName().startsWith("is") || mth.getName().equals("getClass") || Void.TYPE.equals(mth.getReturnType()) || mth.getGenericParameterTypes().length >= 1) continue;
                getMths.add(mth);
            }
            return getMths;
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Method> getAllSetterMethod(Class<?> type) {
        try {
            Method[] mths = type.getMethods();
            ArrayList<Method> setMths = new ArrayList<Method>();
            for (Method mth : mths) {
                String methodName = mth.getName();
                if (!methodName.startsWith("set") || methodName.length() < 4 || mth.getGenericParameterTypes().length != 1) continue;
                setMths.add(mth);
            }
            return setMths;
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object invokeNoParamFunc(Object demander, String smethod) {
        try {
            Method method = demander.getClass().getMethod(smethod, new Class[0]);
            return method.invoke(demander, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object invokeMethod(Object demander, String smethod, Object ... params) {
        if (params == null) {
            return ReflectionOpt.invokeNoParamFunc(demander, smethod);
        }
        try {
            Class[] types = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
            Method method = demander.getClass().getMethod(smethod, types);
            return method.invoke(demander, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> Object invokeBinaryOpt(T demander, String smethod, T param) {
        try {
            Method setV = demander.getClass().getMethod(smethod, demander.getClass());
            return setV.invoke(demander, param);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        assert (object != null);
        assert (methodName != null && !methodName.isEmpty());
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException e) {
                logger.debug("\u65b9\u6cd5\u4e0d\u5728\u5f53\u524d\u7c7b\u5b9a\u4e49,\u7ee7\u7eed\u5411\u4e0a\u8f6c\u578b");
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        if (!accessible) {
            ((Method)method).setAccessible(true);
        }
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!accessible) {
            ((Method)method).setAccessible(accessible);
        }
        return result;
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionOpt.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static boolean isPrimitiveType(Class<?> tp) {
        return tp.isPrimitive() || tp.getName().startsWith("java.lang.");
    }

    public static boolean isScalarType(Class<?> tp) {
        if (tp.isPrimitive()) {
            return true;
        }
        if (tp.isArray()) {
            return false;
        }
        String tpName = tp.getPackage().getName();
        if (tpName.equals("java.lang") || tpName.equals("java.sql")) {
            return true;
        }
        if (Number.class.isAssignableFrom(tp)) {
            return true;
        }
        if (Date.class.isAssignableFrom(tp)) {
            return true;
        }
        return UUID.class.isAssignableFrom(tp);
    }

    public static boolean isNumberType(Class<?> tp) {
        return Number.class.isAssignableFrom(tp);
    }

    public static boolean isArray(Object obj) {
        Class<?> tp = obj.getClass();
        if (tp.isArray()) {
            return true;
        }
        return obj instanceof Collection;
    }

    public static boolean isArrayType(Class<?> tp) {
        if (tp.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(tp);
    }

    public static String getCurrentMethodName() {
        return Thread.currentThread().getStackTrace()[1].getMethodName();
    }

    public static String getJavaTypeName(Class<?> type) {
        String typeName = type.getTypeName();
        if (typeName.indexOf(46) < 1) {
            return typeName;
        }
        if (typeName.startsWith("java.lang.") || "java.util.Date".equals(typeName) || "java.sql.Clob".equals(typeName) || "java.sql.Blob".equals(typeName) || "java.util.UUID".equals(typeName) || "java.math.BigDecimal".equals(typeName) || "java.math.BigInteger".equals(typeName)) {
            return FileType.getFileExtName(typeName);
        }
        if (typeName.startsWith("java.sql.")) {
            return "sql" + FileType.getFileExtName(typeName);
        }
        return typeName;
    }

    public <T> T createObjectFromMap(Class<T> clazz, Map<String, Object> properties) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        T obj = clazz.newInstance();
        try {
            Method[] mths;
            for (Method mth : mths = clazz.getMethods()) {
                Object value;
                Type[] paramTypes = mth.getGenericParameterTypes();
                String methodName = mth.getName();
                if (!methodName.startsWith("set") || methodName.length() < 4 || paramTypes.length != 1 || (value = properties.get(methodName.substring(3, 4).toLowerCase() + methodName.substring(4))) == null) continue;
                mth.invoke(obj, value);
            }
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return obj;
    }
}

