/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.xml;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XMLObject {
    protected static final Logger logger = LoggerFactory.getLogger(XMLObject.class);

    private XMLObject() {
        throw new IllegalAccessError("Utility class");
    }

    public static Element createXMLElement(String elementName, String valueType, Object value) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addAttribute("type", valueType);
        element.setText(StringBaseOpt.objectToString(value));
        return element;
    }

    public static Element createXMLElementFromObject(String elementName, Object object) {
        if (object instanceof String) {
            return XMLObject.createXMLElement(elementName, "String", object);
        }
        if (object instanceof Long) {
            return XMLObject.createXMLElement(elementName, "Long", object);
        }
        if (object instanceof BigDecimal) {
            return XMLObject.createXMLElement(elementName, "BigDecimal", object);
        }
        if (object instanceof Boolean) {
            return XMLObject.createXMLElement(elementName, "Boolean", object);
        }
        if (object instanceof Integer) {
            return XMLObject.createXMLElement(elementName, "Integer", object);
        }
        if (object instanceof Number) {
            return XMLObject.createXMLElement(elementName, "Number", object);
        }
        if (object instanceof Date) {
            return XMLObject.createXMLElement(elementName, "Date", object);
        }
        if (object instanceof Map) {
            Element element = DocumentHelper.createElement((String)elementName);
            element.addAttribute("type", "Object");
            element.addAttribute("class", object.getClass().getName());
            for (Map.Entry jo : ((Map)object).entrySet()) {
                if (jo.getValue() == null) continue;
                element.add(XMLObject.createXMLElementFromObject(StringBaseOpt.objectToString(jo.getKey()), jo.getValue()));
            }
            return element;
        }
        if (object instanceof Object[]) {
            Element element = DocumentHelper.createElement((String)elementName);
            element.addAttribute("type", "Array");
            element.addAttribute("class", object.getClass().getName());
            for (Object obj : (Object[])object) {
                if (obj == null) continue;
                element.add(XMLObject.createXMLElementFromObject("item", obj));
            }
            return element;
        }
        if (object instanceof Collection) {
            Element element = DocumentHelper.createElement((String)elementName);
            element.addAttribute("type", "Array");
            element.addAttribute("class", object.getClass().getName());
            for (Object obj : (Collection)object) {
                if (obj == null) continue;
                element.add(XMLObject.createXMLElementFromObject("item", obj));
            }
            return element;
        }
        if (ReflectionOpt.isScalarType(object.getClass())) {
            return XMLObject.createXMLElement(elementName, "String", object);
        }
        JavaBeanMetaData jbm = JavaBeanMetaData.createBeanMetaDataFromType(object.getClass());
        Map<String, JavaBeanField> fields = jbm.getFileds();
        if (fields == null) {
            return XMLObject.createXMLElement(elementName, "String", object);
        }
        Element element = DocumentHelper.createElement((String)elementName);
        element.addAttribute("type", "Object");
        element.addAttribute("class", object.getClass().getName());
        for (Map.Entry<String, JavaBeanField> field : fields.entrySet()) {
            Object obj = field.getValue().getObjectFieldValue(object);
            if (obj == null) continue;
            element.add(XMLObject.createXMLElementFromObject(field.getKey(), obj));
        }
        return element;
    }

    public static String jsonObjectToXMLString(Map<String, Object> json) {
        Element element = XMLObject.createXMLElementFromObject("object", json);
        return element.asXML();
    }

    public static String objectToXMLString(String rootName, Object object) {
        Element element = XMLObject.createXMLElementFromObject(rootName, object);
        return element.asXML();
    }

    public static String objectToXMLString(Object object) {
        return XMLObject.objectToXMLString("object", object);
    }

    public static Object elementToObject(Element element) {
        String stype;
        Attribute attr = element.attribute("type");
        String string = stype = attr == null ? null : element.attribute("type").getValue();
        if (StringUtils.equals((CharSequence)"Date", (CharSequence)stype)) {
            return DatetimeOpt.smartPraseDate(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Long", (CharSequence)stype)) {
            return NumberBaseOpt.castObjectToLong(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Integer", (CharSequence)stype)) {
            return NumberBaseOpt.castObjectToInteger(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Number", (CharSequence)stype)) {
            return NumberBaseOpt.castObjectToDouble(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Boolean", (CharSequence)stype)) {
            return StringRegularOpt.isTrue(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"BigDecimal", (CharSequence)stype)) {
            return new BigDecimal(element.getTextTrim());
        }
        if (StringUtils.equals((CharSequence)"Array", (CharSequence)stype)) {
            List subElements = element.elements();
            if (subElements == null) {
                return null;
            }
            ArrayList<Object> objs = new ArrayList<Object>(subElements.size());
            for (Element subE : subElements) {
                if (!StringUtils.equals((CharSequence)"item", (CharSequence)element.getName())) continue;
                objs.add(XMLObject.elementToObject(subE));
            }
            return objs;
        }
        if (StringUtils.equals((CharSequence)"Object", (CharSequence)stype)) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            List subElements = element.elements();
            if (subElements == null) {
                return null;
            }
            for (Element subE : subElements) {
                objectMap.put(element.getName(), XMLObject.elementToObject(subE));
            }
            return objectMap;
        }
        return element.getTextTrim();
    }

    public static Map<String, Object> elementToJSONObject(Element element) {
        Object obj = XMLObject.elementToObject(element);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static Map<String, Object> xmlStringToJSONObject(String xmlString) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlString);
            return XMLObject.elementToJSONObject(doc.getRootElement());
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object xmlStringToObject(String xmlString) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlString);
            return XMLObject.elementToObject(doc.getRootElement());
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

